mkdir -p results/

TMP=results/tmp
mkdir -p $TMP

for type in expected_wins trueskill ; do
    echo ""
    echo "--------------------------------------------------------------------------"
    echo "system-Level evaluation ($type)"
    echo "--------------------------------------------------------------------------"
    python3 scripts/system_correlation.py --human scores/conll14/system_scores_humans/$type.txt.gz --metrics scores/conll14/system_scores_metrics/*.gz --tablefmt orgtbl 2>&1 | tee results/sys.$type.txt

    echo -e "METRIC\tLP\tTESTSET\tSYSTEM\tSCORE" > $TMP/metrics.ranking.wmt.header.txt
    zcat scores/conll14/system_scores_metrics/*.gz >> $TMP/metrics.ranking.wmt.header.txt
    echo -e "METRIC\tLP\tTESTSET\tSYSTEM\tSCORE" > $TMP/$type.ranking.wmt.header.txt
    zcat scores/conll14/system_scores_humans/$type.txt.gz | sed "s|human|HUMAN|g" >> $TMP/$type.ranking.wmt.header.txt

done

rm -r $TMP
