#!/bin/bash

lang=en-fr
out=sh/results/$lang/consumption

SCRIPT=scripts/env_impact.py

mkdir -p $out
out=$out/power
rm -rf $out.log $out.results
for d in iwslt17 nei; do
    for s in standard split fromsplit standard/fromnei split/fromnei fromsplit/fromnei; do
        for k in k1 k3; do
            logdir=checkpoints/$lang/$d/$s/$k
            echo "logdir: $logdir" >> $out.log
            python $SCRIPT $logdir >> $out.log
            grep "done training" $logdir/logs/train.log >> $out.log
            echo "------------------------------------" >> $out.log
        done
    done
done

grep "logdir\|(KWh)\|done training\|-----" $out.log >> $out.results
cat $out.results



