import argparse
from experiment_impact_tracker.data_interface import DataInterface


def main():
    parser = argparse.ArgumentParser(
        description='Take as input a text file with documents separated by an empty line. '
                    'Remove the empty lines separating the documents and write to a new file. ',
    )
    # fmt: off
    parser.add_argument("logdir", nargs="+",
        help="Impact tracker's logging directory for a given training.")
    # parser.add_argument(
    #     '--fill-size',
    #     type=int,
    #     metavar='N',
    #     default=None,
    #     help='fill output with artificial heads every fill-size lines'
    # )
    # fmt: on
    args = parser.parse_args()

    data = DataInterface(args.logdir)
    print("Electicity consumption (KWh): ", data.total_power)
    # print("Carbon emitted (Kg): ", data.kg_carbon)


if __name__ == '__main__':
    main()