LANGUAGE=$1
MODEL_TYPE=$2
DATA_TYPE=$3
CHECKPOINT=$4
DEVICE=$5

SPM=../sentencepiece/build/src/spm_encode
MODEL=../models/mbart.cc25.v2/sentence.bpe.model
SRC=input
TGT=target
DEST_DIR=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/scores-bin
langs=ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN
DICT=../models/mbart.cc25.v2/dict.txt

DATA_FILE=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_input.predicted
OUT_FILE=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/scores
${SPM} --model=${MODEL} < ${DATA_FILE} > ${OUT_FILE}.spm.${SRC}
DATA_FILE=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_extractions.predicted
${SPM} --model=${MODEL} < ${DATA_FILE} > ${OUT_FILE}.spm.${TGT}

fairseq-preprocess --source-lang ${SRC} --target-lang ${TGT} --destdir ${DEST_DIR} --thresholdtgt 0    --thresholdsrc 0   --srcdict ${DICT}   --tgtdict ${DICT}   --workers 70 --testpref ${OUT_FILE}.spm

CUDA_VISIBLE_DEVICES=${DEVICE} fairseq-generate ${DEST_DIR} --path ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-checkpoints/${CHECKPOINT}  --task translation_from_pretrained_bart --gen-subset test -t target -s input --sacrebleu --remove-bpe 'sentencepiece' --langs $langs --max-sentences 8 --max-source-positions 512  --score-reference > ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_scores_output

# Uncomment for using transformer re-ranking and comment previous line
# CUDA_VISIBLE_DEVICES=${DEVICE} fairseq-generate ${DEST_DIR} --path ../models/${LANGUAGE}/rerank/ctranslate_clp-checkpoints/${CHECKPOINT}  --task translation_from_pretrained_bart --gen-subset test -t target -s input --sacrebleu --remove-bpe 'sentencepiece' --langs $langs --max-sentences 8 --max-source-positions 512  --score-reference > ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_scores_output

cat ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_scores_output  | grep -P "^H" |sort -V |cut -f 2 > ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_scores.predicted