#!/usr/bin/env python
import sys

def comet_score(base, ref):
  with open(base + ".ref-" + ref + ".comet") as f:
    line = f.readlines()[-1]
    assert line.startswith("System score: ")
    return float(line.split()[2])
 
def chrf_score(base, ref):
  with open(base + ".ref-" + ref + ".chrf") as f:
    return float(f.readline())

refs = ["A", "C", "D"]
base = sys.argv[1]
comets = [comet_score(base, ref) for ref in refs]
comet = sum(comets) / len(comets)
chrfs = [chrf_score(base, ref) for ref in refs]
chrf = sum(chrfs) / len(chrfs)
with open(base + ".refs-ACD.bleu") as f:
  bleu = f.readline().strip()
print(bleu + " {:0.3f} {:0.4f}".format(chrf, comet))
