# ASAP
### General Introduction

This folder contains the data of the paper "ASAP: A Chinese Review Dataset Towards Aspect Category Sentiment Analysis and Rating Prediction".

**ASAP** is a large-scale Chinese restaurant review dataset for Aspect category Sentiment Analysis (ACSA) and review rating Prediction (RP).

ASAP includes 46, 730 genuine user reviews from a leading Online-to-Offline (O2O) e-commerce platform. Besides a 5-star scale rating, each review is manually annotated according to its sentiment polarities towards 18 pre-defined aspect categories. We split the dataset into a training set (36,850), a validation set (4,940) and a test set (4,940) randomly.  We also provide 100 samples for viewing easily.

We hope the release of the dataset could shed some light on the fields of sentiment analysis.


### Read File

  ```python
  import pandas as pd
  
  file_path = "sample.csv"
  data = pd.read_csv(file_path, header=0)
  ```
### Data Label

The sentiment polarity over the aspect category is labeled as 1(Positive), 0(Neutral), −1(Negative), −2(Not-Mentioned).

The star rating ranges from 1 to 5.