# parlai.chat_service

ParlAI's chat service functionality.

## Chat Service Core

### parlai.chat_service.core.agents
```{eval-rst}
.. automodule:: parlai.chat_service.core.agents
   :members:
```

### parlai.chat_service.core.core.chat_service_manager
```{eval-rst}
.. automodule:: parlai.chat_service.core.chat_service_manager
   :members:
```

### parlai.chat_service.core.socket
```{eval-rst}
.. automodule:: parlai.chat_service.core.socket
   :members:
```

### parlai.chat_service.core.world_runner
```{eval-rst}
.. automodule:: parlai.chat_service.core.world_runner
   :members:
```

## Services

### Browser Chat

#### parlai.chat_service.services.browser_chat.agents
```{eval-rst}
.. automodule:: parlai.chat_service.services.browser_chat.agents
   :members:
```

#### parlai.chat_service.services.browser_chat.browser_manager
```{eval-rst}
.. automodule:: parlai.chat_service.services.browser_chat.browser_manager
   :members:
```

### Messenger

#### parlai.chat_service.services.messenger.agents
```{eval-rst}
.. automodule:: parlai.chat_service.services.messenger.agents
   :members:
```

#### parlai.chat_service.services.messenger.message_sender
```{eval-rst}
.. automodule:: parlai.chat_service.services.messenger.message_sender
   :members:
```

#### parlai.chat_service.services.messenger.messenger_manager
```{eval-rst}
.. automodule:: parlai.chat_service.services.messenger.messenger_manager
   :members:
```

#### parlai.chat_service.services.messenger.worlds
```{eval-rst}
.. automodule:: parlai.chat_service.services.messenger.worlds
   :members:
```

### Terminal Chat

#### parlai.chat_service.services.terminal_chat.agents
```{eval-rst}
.. automodule:: parlai.chat_service.services.terminal_chat.agents
   :members:
```

#### parlai.chat_service.services.terminal_chat.terminal_manager
```{eval-rst}
.. automodule:: parlai.chat_service.services.terminal_chat.terminal_manager
   :members:
```

### Websocket

#### parlai.chat_service.services.websocket.agents
```{eval-rst}
.. automodule:: parlai.chat_service.services.websocket.agents
   :members:
```

#### parlai.chat_service.services.websocket.sockets
```{eval-rst}
.. automodule:: parlai.chat_service.services.websocket.sockets
   :members:
```

#### parlai.chat_service.services.websocket.websocket_manager
```{eval-rst}
.. automodule:: parlai.chat_service.services.websocket.websocket_manager
   :members:
```

## Utilities

### parlai.chat_service.utils.config
```{eval-rst}
.. automodule:: parlai.chat_service.utils.config
   :members:
```

### parlai.chat_service.utils.image
```{eval-rst}
.. automodule:: parlai.chat_service.utils.image
   :members:
```

### parlai.chat_service.utils.logging
```{eval-rst}
.. automodule:: parlai.chat_service.utils.logging
   :members:
```

### parlai.chat_service.utils.misc
```{eval-rst}
.. automodule:: parlai.chat_service.utils.misc
   :members:
```

### parlai.chat_service.utils.server
```{eval-rst}
.. automodule:: parlai.chat_service.utils.server
   :members:
```

### parlai.chat_service.utils.timeout
```{eval-rst}
.. automodule:: parlai.chat_service.utils.timeout
   :members:
```