/*
 * Decompiled with CFR 0.152.
 */
package parentical_parsers;

import java.util.TreeSet;

public class SRLColParser {
    private String verb;
    private String role;
    private TreeSet<String> roleconf;
    private int size;
    private boolean close;

    public SRLColParser() {
        this.verb = "-";
        this.role = "*";
        this.size = 0;
        this.close = false;
        this.roleconf = new TreeSet();
    }

    public SRLColParser(String v, String r, int s) {
        this.verb = v;
        this.role = r;
        this.size = s;
        this.close = false;
        this.roleconf = new TreeSet();
    }

    public String getVerb() {
        return this.verb;
    }

    public String getRole() {
        return this.role;
    }

    public String getRoleconf() {
        String sroleconf = "";
        for (String tmprole : this.roleconf) {
            if (sroleconf.length() > 0) {
                sroleconf = sroleconf + ",";
            }
            sroleconf = sroleconf + tmprole;
        }
        if (sroleconf.equals("")) {
            sroleconf = "-";
        }
        return sroleconf;
    }

    public void setRole(String r) {
        this.role = r;
    }

    public int getSize() {
        if (this.role.equals("*")) {
            return 0;
        }
        if (this.close) {
            return this.size;
        }
        return this.size + 1;
    }

    public void parse(String s) {
        s = s.trim();
        boolean just_open = false;
        if (this.close) {
            this.close = false;
            this.role = "*";
            this.size = 0;
        }
        if (s.matches("\\*")) {
            if (!this.role.equals("*")) {
                ++this.size;
            }
        } else {
            if (s.matches("\\(.*")) {
                this.role = s.substring(1, s.indexOf(42));
                this.roleconf.add(this.role);
                this.size = 1;
                just_open = true;
            }
            if (s.matches(".*\\)")) {
                if (!just_open) {
                    ++this.size;
                }
                this.close = true;
            }
        }
    }
}

