#!/bin/bash

model_type=$2


if [ $1 == "xnlu_english" ]
then
    python main.py --task xnlu \
                   --train_languages en \
                   --dev_languages en \
                   --test_languages en \
                   --model_dir xnlu_english \
                   --do_train \
                   --do_eval \
                   --cuda_device cuda:0 \
                   --train_batch_size 10 \
                   --eval_batch_size 10 \
                   --num_train_epochs 10 \
                   --learning_rate 0.000015 \
                   --save_model \
                   --model_type $2 \
                   --max_seq_len 50
fi

if [ $1 == "xnlu_aligned" ]
then
    for lang in es th
    do
        python main.py --task xnlu \
                       --train_languages en \
                       --dev_languages $lang \
                       --test_languages $lang \
                       --model_dir xnlu_aligned_$lang \
                       --do_train \
                       --do_eval \
                       --cuda_device cuda:0 \
                       --train_batch_size 10 \
                       --eval_batch_size 10 \
                       --num_train_epochs 10 \
                       --learning_rate 0.000015 \
                       --align_languages $lang \
                       --save_model \
                       --model_type $2 \
                       --max_seq_len 50
    done
fi

if [ $1 == "xnlu_aligned_all" ]
then
    python main.py --task xnlu \
                   --train_languages en \
                   --dev_languages en \
                   --test_languages en \
                   --model_dir xnlu_aligned_all \
                   --do_train \
                   --do_eval \
                   --cuda_device cuda:0 \
                   --train_batch_size 10 \
                   --eval_batch_size 10 \
                   --num_train_epochs 15 \
                   --learning_rate 0.000015 \
                   --align_languages es,th \
                   --save_model \
                   --model_type $2 \
                   --max_seq_len 50
fi

if [ $1 == "xnlu_zero_shot" ]
then
    for lang in es th
    do
        python main.py --task xnlu \
                       --train_languages $lang \
                       --dev_languages $lang \
                       --test_languages $lang \
                       --model_dir xnlu_zero_shot_$lang \
                       --do_eval \
                       --cuda_device cuda:0 \
                       --eval_batch_size 10 \
                       --model_type $2 \
                       --load_eval_model xnlu_english \
                       --max_seq_len 50
    done
fi

if [ $1 == "xnlu_target" ]
then
    for lang in es th
    do
        python main.py --task xnlu \
                       --train_languages $lang \
                       --dev_languages $lang \
                       --test_languages $lang \
                       --model_dir xnlu_target_$lang \
                       --do_eval \
                       --do_train \
                       --cuda_device cuda:0 \
                       --train_batch_size 10 \
                       --eval_batch_size 10 \
                       --num_train_epochs 10 \
                       --learning_rate 0.000015 \
                       --model_type $2 \
                       --max_seq_len 50
    done
fi

if [ $1 == "xnlu_eval" ]
then
    for lang in en es th
    do
        python main.py --task xnlu \
                       --train_languages $lang \
                       --dev_languages $lang \
                       --test_languages $lang \
                       --model_dir xnlu_eval_$lang \
                       --do_eval \
                       --cuda_device cuda:0 \
                       --eval_batch_size 16 \
                       --load_eval_model xnlu_aligned \
                       --model_type $2 \
                       --max_seq_len 70
    done
fi
