import re

FIELDS = r"^(ABSTRACT|AIMS|AIM|ANALYSIS|AND|APPRAISAL|AREAS|ASSESSMENT|AUTHORS ' CONCLUSIONS|AUTHORS'|AUTHORS|" + \
    "BACKGROUND|BENEFITS|BMC|BMI|" + \
    "CAUTION|CENTRAL|CINAHL|CINHAL|CLINICAL|COLLECTION|Conclusions and Relevance|CONCLUSIONS|CONCLUSION|CONTEXT|COPD|CRITERIA|" + \
    "DATA|DATE|DESIGN|DISCUSSION|DURATION|" + \
    "ELIGIBILITY|EMBASE|EVIDENCE|EXTRACTION|" + \
    "FDA|FINDINGS|FUNDING|" + \
    "GOALS|GOAL|GRADE|GUIDELINES|GUIDELINE|" + \
    "IDENTIFICATION|IMPLICATION|IMPLICATIONS|IMPORTANCE|INCLUSION|INTERPRETATION|INTERVENTIONS|INTRODUCTION|" + \
    "LANGUAGE|LILACS|LIMITATIONS|LITERATURE|" + \
    "MATERIAL|MATERIALS|MEASUREMENTS|MEASURES|MEDLINE|METHODS|METHODOLOGY|METHOD|" + \
    "OBJECTIVES|OBJECTIVE|OUTCOMES|OUTCOME|" + \
    "PARTICIPANTS|PATIENTS|POPULATION|PRACTICE|PRIMARY|PRISMA|PROCEDURES|PROSPECT|PROSPERO|PROTOCOL|PUBMED|PURPOSE|PsycINFO|" + \
    "QUALITY|QUESTIONS|QUESTION|" + \
    "RATIONALE|RCTS|RCTs|RCT|REASONS|RECENT FINDINGS|RECOMMENDATIONS|RECOMMENDATION|REGISTRATION|RELEVANCE|RESEARCH|RESULTS|RESULT|REVIEW ER 'S CONCLUSIONS|REVIEWER'S|REVIEWERS'|REVIEWERS|REVIEW|" + \
    r"SAMPLE|SCOPUS|SEARCH|SECONDARY|SELECTING|SELECTION|SETTING|SIGNIFICANCE|SOURCES|SOURCE|SPORTD|STRATEGY|STUDIES|STUDY|SUMMARY|SYNTHESIS|SYSTEMATIC)"

fields_re = re.compile(FIELDS, flags=re.IGNORECASE)
spaces_re = re.compile(r'\s(\s)+', flags=re.DOTALL)

def insert_spaces(s: str) -> str:
    # surround any likely offending section headings or paragraph starts with spaces
    with_spaces = re.sub(fields_re, r' \1 ', s)
    # replace all double (or n) space characters with a single matching one
    with_single_spaces = re.sub(spaces_re, r'\1', with_spaces)
    return with_single_spaces
