import React, { Component } from 'react';
import { Meteor } from 'meteor/meteor';

import Token from './Token.jsx';
import Label from './Label.jsx';

function compareMentions(a, b, evenOverlap=false) {
  if (a == undefined || b == undefined) {
    return a == b;
  } else {
    if (evenOverlap) {
      const left = (a.end < b.start);
      const right = (b.end < a.start);
      return ! (left || right);
    } else {
      return a.start == b.start && a.end == b.end && a.label == b.label;
    }
  }
}

export default class Mention extends Component {
  constructor(props) {
    super(props);

    this.mouseEnter = this.mouseEnter.bind(this);
    this.mouseLeave = this.mouseLeave.bind(this);
    this.mouseDown = this.mouseDown.bind(this);
    this.mouseUp = this.mouseUp.bind(this);
    this.mouseEnterX = this.mouseEnterX.bind(this);
    this.mouseLeaveX = this.mouseLeaveX.bind(this);
    this.mouseDownX = this.mouseDownX.bind(this);
    this.mouseUpX = this.mouseUpX.bind(this);
    this.click = this.click.bind(this);

    this.state = {
      overX: false,
    };
  }

  shouldComponentUpdate(nextProps, nextState) {
    if (this.props.tokens != nextProps.tokens) return true;
    if (this.props.ui != nextProps.ui) return true;
    if (this.props.forceSelected != nextProps.forceSelected) return true;
    if (this.props.focusMention != nextProps.focusMention) return true;
    if (this.props.currentToken != nextProps.currentToken) return true;
    if (this.props.endSelected != nextProps.endSelected) return true;
    if (this.props.startSelected != nextProps.startSelected) return true;
    if (this.props.readOnly != nextProps.readOnly) return true;
    if (this.props.depth != nextProps.depth) return true;
    if (this.props.maxDepth != nextProps.maxDepth) return true;
    if (this.props.lineHeight != nextProps.lineHeight) return true;
    if (this.props.labelOptions != nextProps.labelOptions) return true;
    if (this.props.checks != nextProps.checks) return true;
    if (this.props.selectedCluster != nextProps.selectedCluster) return true;
    if (this.props.ui != "freq-ents") {
      if (this.props.mentionMap != nextProps.mentionMap) return true;
    }

    if (
      (! compareMentions(this.props.thisMention.mention, nextProps.thisMention.mention)) ||
      this.props.thisMention.hint != nextProps.thisMention.hint ||
      this.props.thisMention.color != nextProps.thisMention.color) {
      return true;
    }

    if (! compareMentions(this.props.selectedMention, nextProps.selectedMention)) {
      if (
        compareMentions(this.props.selectedMention, this.props.thisMention.mention, true) ||
        compareMentions(nextProps.selectedMention, this.props.thisMention.mention, true)
      ) return true;
    }

    return false;
  }

  mouseEnter = (e) => {
    if (this.props.thisMention.hint != "include") {
      this.props.onMouseEnterMention(this.props.thisMention.mention, e.shiftKey, e.altKey);
    }
  }
  mouseLeave = (e) => {
    if (this.props.thisMention.hint != "include") {
      this.props.onMouseLeaveMention(this.props.thisMention.mention, e.shiftKey, e.altKey);
    }
  }
  mouseDown = (e) => {
    if (this.props.thisMention.hint != "include") {
      this.props.onMouseDownMention(this.props.thisMention.mention, e.shiftKey, e.altKey);
      e.stopPropagation();
    }
  }
  mouseUp = (e) => {
    if (this.props.thisMention.hint != "include") {
      this.props.onMouseUpMention(this.props.thisMention.mention, e.shiftKey, e.altKey);
      e.stopPropagation();
    }
  }
  click = (e) => {
    if (this.props.thisMention.hint != "include") {
      this.props.onClickMention(this.props.thisMention.mention, e.shiftKey, e.altKey);
      e.stopPropagation();
    }
  }

  mouseEnterX = (e) => {
    this.setState({
      overX: true,
    });
  }
  mouseLeaveX = (e) => {
    this.setState({
      overX: false,
    });
  }
  mouseDownX = (e) => {
    e.stopPropagation();
  }
  mouseUpX = (e) => {
    this.props.onMouseUpMention(this.props.thisMention.mention, e.shiftKey, true);
    e.stopPropagation();
  }

  determineColor(mention) {
    if (this.props.ui.startsWith("check-mentions")) {
      if (mention.hint == "include") {
        return "green";
      } else if (mention.hint == "exclude") {
        return "orange";
      } else {
        if (mention.label == "") {
          return "orange";
        } else {
          return "purple";
        }
      }
    } else if (
      this.props.ui == "mentions" ||
      this.props.ui == "conditionals" ||
      this.props.ui == "actions" ||
      this.props.ui == "conditionals-from-actions" ||
      this.props.ui == "one-entity-at-a-time" ||
      this.props.ui == "link-to-one-before" ||
      this.props.ui == "link-to-one-after"
    ) {
      if (mention.hint == "include") {
        return "green";
      } else if (mention.hint == "exclude") {
        return "orange";
      }
    }

    if (mention.color != undefined) {
      return mention.color;
    } else {
      return "#7570b3";
    }
  }

  nameToColor(name, shade) {
    if (name == "orange") {
      if (shade == "light") return "#fff0f1";
      else return "#d95f02";
    } else if (name == "green") {
      if (shade == "light") return "#f0fff4";
      else return "#1b9e77";
    } else if (name == "purple") {
      if (shade == "light") return "#f4f0ff";
      else return "#7570b3";
    } else {
      if (shade == "light") return "#f0f8ff";
      else if (/^#.*/.test(name)) return name;
      else return "#7570b3";
    }
  }

  render() {
    const start = this.props.thisMention.mention.start;
    const end = this.props.thisMention.mention.end;
    const label = this.props.thisMention.mention.label;
    const isGoldHint = (this.props.thisMention.hint == "include");

    const colorName = this.determineColor(this.props.thisMention);
    const darkColor = this.nameToColor(colorName, "dark");
    const lightColor = this.nameToColor(colorName, "light");

    const isFocus = this.props.focusMention != null &&
      this.props.focusMention.start == start &&
      this.props.focusMention.end == end
    const clickable = ! isFocus;

    var checked = false;
    if (this.props.checks != undefined && this.props.ui.includes("include")) {
      this.props.checks.forEach(check => {
        if (
          check.mention.start == start &&
          check.mention.end == end &&
          check.mention.label == label &&
          check.decision == "keep"
        ) {
          checked = true;
        }
      });
    }

    var selected = checked || this.props.forceSelected ||
      (
        this.props.selectedCluster &&
        (this.props.ui != "conditionals-from-actions" || isFocus) &&
        this.props.selectedCluster.mentions.some(other => {
          return other.start == start && other.end == end;
        })
      ) ||
        (this.props.selectedMention &&
        this.props.selectedMention.start <= start &&
        this.props.selectedMention.end >= end);

    if (this.props.ui.includes('exclude')) {
      selected = ! selected;
    }
    if (isGoldHint) {
      selected = false;
    }
    if (this.props.ui == "freq-ents") {
      if (this.props.thisMention.mention.label != "") {
        selected = true;
      }
    }

    var next_token = -1;
    const data = this.props.tokens.slice(start, end + 1).map((token) => {
      if (token._id < next_token) {
        // Skip, as we are covering it in a mention
      } else {
        const shorter = this.props.mentionMap[token._id].reduce((largest, pair) => {
          if (pair.mention.end == end && pair.mention.start == start) {
            return largest;
          } else if (pair.mention.end <= end && pair.mention.start >= start) {
            if (largest == null || pair.mention.end > largest.mention.end) {
              return pair;
            } else {
              return largest;
            }
          } else {
            return largest;
          }
        }, null);
        if ((! isFocus) && shorter != null) {
          next_token = shorter.mention.end + 1;
          return (
            <Mention
              tokens={this.props.tokens}
              checks={this.props.checks}
              key={token._id}
              thisMention={shorter}
              ui={this.props.ui}
              mentionMap={this.props.mentionMap}
              forceSelected={selected && this.props.ui.startsWith("link-to-one")}
              focusMention={this.props.focusMention}
              selectedCluster={this.props.selectedCluster}
              selectedMention={this.props.selectedMention}
              onMouseEnter={this.props.onMouseEnter}
              onMouseLeave={this.props.onMouseLeave}
              onMouseDown={this.props.onMouseDown}
              onMouseUp={this.props.onMouseUp}
              onClick={this.props.onClick}
              onDoubleClick={this.props.onDoubleClick}
              onMouseEnterMention={this.props.onMouseEnterMention}
              onMouseLeaveMention={this.props.onMouseLeaveMention}
              onMouseDownMention={this.props.onMouseDownMention}
              onMouseUpMention={this.props.onMouseUpMention}
              onClickMention={this.props.onClickMention}
              onMouseDownLabel={this.props.onMouseDownLabel}
              onMouseUpLabel={this.props.onMouseUpLabel}
              currentToken={this.props.currentToken}
              endSelected={this.props.endSelected}
              startSelected={this.props.startSelected}
              readOnly={this.props.readOnly}
              depth={this.props.depth + 1}
              maxDepth={this.props.maxDepth}
              lineHeight={this.props.lineHeight}
              labelOptions={this.props.labelOptions}
              parentSelected={selected}
            />
          );
        } else {
          return (
            <Token 
              token={token} 
              key={token._id}
              noPointer={!clickable}
              ui={this.props.ui}
              onMouseEnter={this.props.onMouseEnter}
              onMouseLeave={this.props.onMouseLeave}
              onMouseDown={this.props.onMouseDown}
              onMouseUp={this.props.onMouseUp}
              onClick={this.props.onClick}
              onDoubleClick={this.props.onDoubleClick}
              currentToken={this.props.currentToken}
              endSelected={this.props.endSelected}
              startSelected={this.props.startSelected}
              readOnly={this.props.readOnly}
              depth={this.props.depth + 1}
              maxDepth={this.props.maxDepth}
              lineHeight={this.props.lineHeight}
              isSelected={selected ? darkColor : 'white'}
              backgroundColor={lightColor}
            />
          );
        }
      }
    });

    const className = "mention" + (
      clickable && (!this.props.readOnly) ? " pointer" : ""
    );
    var displayLabel = "";
    if (this.props.thisMention.mention.label != undefined) {
      const labelContent = this.props.thisMention.mention.label;
      displayLabel = [
         (<div key="1" className="clear"></div>),
      ];
      var first = true;
      if ( this.props.labelOptions != null) {
        this.props.labelOptions.forEach(label => {
          if (labelContent == "" || labelContent == label || this.props.ui == "freq-ents") {
            const divStyle = {
              borderColor: selected ? lightColor : darkColor,
              backgroundColor: selected ? darkColor : lightColor,
              color: selected ? 'white' : 'black',
            };
            const altDivStyle = {
              borderColor: ! selected ? lightColor : darkColor,
              backgroundColor: ! selected ? darkColor : lightColor,
              color: ! selected ? 'white' : 'black',
            };
            displayLabel.push(
              (<Label
                key={label}
                label={label}
                style={divStyle}
                altStyle={altDivStyle}
                isFirst={first}
                isChosen={labelContent == label}
                readOnly={this.props.readOnly || isGoldHint}
                mentionMap={this.props.mentionMap}
                onMouseDown={this.props.onMouseDownLabel}
                onMouseUp={this.props.onMouseUpLabel}
                mention={this.props.thisMention.mention}
              />));
            first = false;
          }
        });
      }
    }

    var finalDivStyle = {
      borderColor: selected ? (this.props.parentSelected ? lightColor : darkColor) : darkColor,
      backgroundColor: selected ? darkColor : lightColor,
      color: selected ? 'white' : 'black',
      marginBottom: "1px",
    };
    const removeLabel = isGoldHint || this.props.ui == "freq-ents" ? "" : (
      <span
        onMouseEnter={this.mouseEnterX}
        onMouseLeave={this.mouseLeaveX}
        onMouseDown={this.mouseDownX}
        onMouseUp={this.mouseUpX}
        className={"remove-mention " + (this.state.overX ? "inX" : "outX")}
      >
      </span>
    );
    const coreMention = (
      <span
        onMouseEnter={this.mouseEnter}
        onMouseLeave={this.mouseLeave}
        onMouseDown={this.mouseDown}
        onMouseUp={this.mouseUp}
        onClick={this.click}
        className={className}
        style={finalDivStyle}
      >
      {data}
      {displayLabel}
      {removeLabel}
      </span>
    );
    if (this.props.depth != 0) {
      return coreMention;
    } else {
      return (
        <span
          className="outer-mention"
          style={{boxSizing: "border-box", height: this.props.lineHeight.toString() + "px"}}
        >
        {coreMention}
        </span>
      );
    }
  }
}
