import argparse

import init

parser = argparse.ArgumentParser(description='Submit a set of HITs.')
parser.add_argument('-s', '--sandbox', help='Do on the sandbox', action='store_true')
args = parser.parse_args()

client = init.get_client(args.sandbox)

minHITs = 501
maxHITs = 1000
minApproved = 99
maxApproved = None

reqs = [
    { # Number of approved hits >= minHITs
        'IntegerValues': [ minHITs, ], 'Comparator': 'GreaterThanOrEqualTo',
        'QualificationTypeId': '00000000000000000040', 'ActionsGuarded': 'DiscoverPreviewAndAccept'
    },
    { # % approved >= minApproved
        'IntegerValues': [ minApproved, ], 'Comparator': 'GreaterThanOrEqualTo',
        'QualificationTypeId': '000000000000000000L0', 'ActionsGuarded': 'DiscoverPreviewAndAccept'
    },
    { # Location = US
        'LocaleValues': [ { 'Country': 'US' }, ], 'Comparator': 'EqualTo',
        'QualificationTypeId': '00000000000000000071', 'ActionsGuarded': 'DiscoverPreviewAndAccept'
    },
]
if maxApproved is not None:
    reqs.append(
        { # % approved < maxApproved
            'IntegerValues': [ maxApproved, ], 'Comparator': 'LessThan',
            'QualificationTypeId': '000000000000000000L0', 'ActionsGuarded': 'DiscoverPreviewAndAccept'
        })
if maxHITs is not None:
    reqs.append(
        { # Number of approved hits < maxHITs
            'IntegerValues': [ maxHITs, ], 'Comparator': 'LessThan',
            'QualificationTypeId': '00000000000000000040', 'ActionsGuarded': 'DiscoverPreviewAndAccept'
        })

response = client.create_hit_type(
    AutoApprovalDelayInSeconds=6 * 60 * 60, # 6 hours before HITs are auto-approved
    AssignmentDurationInSeconds=3 * 60 * 60, # 3 hours for the worker to complete the HIT
    Reward='0.80', # 80 cents per HIT
    Title='Example title',
    Keywords='example,keywords,comma,separated',
    Description='Example description',
    QualificationRequirements=reqs,
)

print("HIT Type created", response)
hit_type = response['HITTypeId']

link_to_page = """<?xml version="1.0" encoding="UTF-8"?>
<ExternalQuestion xmlns="http://mechanicalturk.amazonaws.com/AWSMechanicalTurkDataSchemas/2006-07-14/ExternalQuestion.xsd">
<ExternalURL>"""+ YOUR_URL +"""</ExternalURL>
<FrameHeight>0</FrameHeight>
</ExternalQuestion>"""

remaining_assignments = 15 # Number of workers you want to do your task for this condition
while remaining_assignments > 0:
    response = client.create_hit_with_hit_type(
        HITTypeId=hit_type,
        MaxAssignments=min(9, remaining_assignments),
        LifetimeInSeconds=5 * 24 * 60 * 60, # Tasks are available for 5 days
        Question=link_to_page,
    )
    print("HIT created", response)
    remaining_assignments -= 9

