# -*- coding: utf-8 -*-


def pretty_format_table(table, sep=' ', line_start='', line_end=''):
    table = [[(str(cell) if not isinstance(cell, str) else cell) for cell in row]
             if not isinstance(row, str) else row
             for row in table]
    lengths = [0] * max(map(len, table))
    for row in table:
        if isinstance(row, str):
            continue

        for column_index, cell in enumerate(row):
            lengths[column_index] = max(len(cell), lengths[column_index])

    row_width = sum(lengths) + (len(lengths) - 1) * len(sep)
    lines = []
    for row in table:
        if isinstance(row, str):
            if row == '---':
                row = '-' * row_width
            lines.append(line_start + row + line_end)
            continue
        line = sep.join(('{:%ds}' % (length)).format(cell) for length, cell in zip(lengths, row))
        lines.append(line_start + line + line_end)

    return '\n'.join(lines)
