/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.Exceptions;
import fig.basic.Pair;
import fig.servlet.Item;
import fig.servlet.WebState;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Set;

public class UpdateQueue {
    private LinkedList<Item>[] queues = new LinkedList[3];
    private IdentityHashMap<Item, Priority> priorities;
    private Set<Item> enqueuedItems;

    public UpdateQueue() {
        int i = 0;
        while (i < 3) {
            this.queues[i] = new LinkedList();
            ++i;
        }
        this.priorities = new IdentityHashMap();
        this.enqueuedItems = new HashSet<Item>();
    }

    public synchronized int queueSize() {
        int sum = 0;
        int i = 0;
        while (i < 3) {
            sum += this.queues[i].size();
            ++i;
        }
        return sum;
    }

    private int priorityToIndex(Priority priority) {
        if (priority == Priority.HIGH) {
            return 0;
        }
        if (priority == Priority.MED) {
            return 1;
        }
        if (priority == Priority.LOW) {
            return 2;
        }
        throw Exceptions.unknownCase;
    }

    private Priority indexToPriority(int i) {
        if (i == 0) {
            return Priority.HIGH;
        }
        if (i == 1) {
            return Priority.MED;
        }
        if (i == 2) {
            return Priority.LOW;
        }
        throw Exceptions.unknownCase;
    }

    private synchronized void removeItem(Item item) {
        Priority priority = this.priorities.remove(item);
        if (priority != null) {
            this.queues[this.priorityToIndex(priority)].remove(item);
        }
    }

    public synchronized void enqueue(Item item, Priority priority) {
        if (this.enqueueHelper(item, priority) && WebState.logUpdates) {
            WebState.logs("UpdateQueue(+" + priority + ") " + item.getTrail().toDisplayString());
        }
    }

    private synchronized boolean enqueueHelper(Item item, Priority priority) {
        if (item.isDead) {
            return false;
        }
        this.enqueuedItems.add(item);
        Priority oldPriority = this.priorities.get(item);
        if (oldPriority == priority) {
            return false;
        }
        this.removeItem(item);
        this.queues[this.priorityToIndex(priority)].addLast(item);
        this.priorities.put(item, priority);
        return true;
    }

    public synchronized void merge(UpdateQueue queue) {
        int i = 0;
        while (i < 3) {
            for (Item item : queue.queues[i]) {
                this.enqueueHelper(item, this.indexToPriority(i));
            }
            ++i;
        }
    }

    public synchronized Pair<Item, Priority> dequeue() {
        int i = 0;
        while (i < 3) {
            if (this.queues[i].size() != 0) {
                Item item = this.queues[i].removeFirst();
                Priority priority = this.priorities.remove(item);
                if (WebState.logUpdates) {
                    WebState.logs("UpdateQueue(-" + this.indexToPriority(i) + ") " + item.getTrail().toDisplayString());
                }
                return new Pair<Item, Priority>(item, priority);
            }
            ++i;
        }
        return null;
    }

    public synchronized void clearEnqueued() {
        this.enqueuedItems.clear();
    }

    public String toString() {
        return String.format("UpdateQueue(%d/%d/%d items)", this.queues[0].size(), this.queues[1].size(), this.queues[2].size());
    }

    public static class Priority {
        private int value;
        public static Priority HIGH = new Priority(0);
        public static Priority MED = new Priority(1);
        public static Priority LOW = new Priority(2);

        private Priority(int value) {
            this.value = value;
        }

        public Priority next() {
            if (this == HIGH) {
                return MED;
            }
            if (this == MED) {
                return LOW;
            }
            return LOW;
        }

        public String toString() {
            return "" + this.value;
        }
    }
}

