###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

#####################################################################
######################################################################

require "scripts/umnlp.rb"

$error = false
$line = ""

class Tree
  def lcPret ( )

    ## preterminal case, right child post-transform
    if @children.size==1 && @children[0].children.size==0
      if @head =~ /\!ldelim\!/
        lAndc = @head.split /\!ldelim\!/
        @head = lAndc[0] + "!ldelim!" + lAndc[1].downcase
      else
        @head.downcase!
      end
      return
    end

    ## unary case
    if @children.size==1
      @children[0].lcPret
      return
    end

    ## binary case
    if @children.size==2
      @children[0].lcPret
      @children[1].lcPret
      return
    end

    $stderr.print "ERROR: N-ARY BRANCH IN RCTREE!!!\n"
    return

  end
end

while($line = gets)
  t = Tree.new($line)
  t.lcPret
  if t.prob != nil
    puts "#{t.to_s} : #{t.prob}"
  else
    print t.to_s + "\n"
  end
end
