/*
 * Decompiled with CFR 0.152.
 */
package babel.util.dict;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.SimpleEquivalenceClass;
import babel.content.eqclasses.properties.context.Context;
import babel.util.dict.SimpleDictionary;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Dictionary {
    protected HashMap<EquivalenceClass, HashSet<EquivalenceClass>> m_map;
    protected HashMap<Long, EquivalenceClass> m_srcMap;
    protected HashMap<Long, EquivalenceClass> m_trgMap;
    protected String m_name;

    public Dictionary(Set<EquivalenceClass> srcEqs, Set<EquivalenceClass> trgEqs, SimpleDictionary simpleDict, String name) {
        this.m_name = name;
        this.m_map = new HashMap();
        this.m_srcMap = new HashMap();
        this.m_trgMap = new HashMap();
        this.costruct(srcEqs, trgEqs, simpleDict);
    }

    public Dictionary(Set<EquivalenceClass> srcEqs, SimpleDictionary simpleDict, String name) {
        this(srcEqs, null, simpleDict, name);
    }

    public void retainAllSrc(Set<EquivalenceClass> srcEqs) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> oldMap = this.m_map;
        HashMap<Long, EquivalenceClass> oldSrcMap = this.m_srcMap;
        this.m_map = new HashMap();
        this.m_srcMap = new HashMap();
        this.m_trgMap.clear();
        for (EquivalenceClass sEq : srcEqs) {
            EquivalenceClass otherSrcEq = oldSrcMap.get(sEq.getId());
            if (otherSrcEq == null) continue;
            this.addTranslation(otherSrcEq, (Set<EquivalenceClass>)oldMap.get(otherSrcEq));
        }
    }

    public void removeAllSrc(Set<EquivalenceClass> srcEqs) {
        HashMap<EquivalenceClass, HashSet<EquivalenceClass>> oldMap = this.m_map;
        this.m_map = new HashMap();
        this.m_srcMap.clear();
        this.m_trgMap.clear();
        HashSet<Long> srcIds = new HashSet<Long>();
        for (EquivalenceClass sEq : srcEqs) {
            srcIds.add(sEq.getId());
        }
        for (EquivalenceClass otherSrcEq : oldMap.keySet()) {
            if (srcIds.contains(otherSrcEq.getId())) continue;
            this.addTranslation(otherSrcEq, (Set<EquivalenceClass>)oldMap.get(otherSrcEq));
        }
    }

    protected void addTranslation(EquivalenceClass srcEq, Set<EquivalenceClass> trgEqSet) {
        this.m_srcMap.put(srcEq.getId(), srcEq);
        HashSet<EquivalenceClass> ourTrgEqSet = this.m_map.get(srcEq);
        if (ourTrgEqSet == null) {
            ourTrgEqSet = new HashSet();
            this.m_map.put(srcEq, ourTrgEqSet);
        }
        for (EquivalenceClass tEq : trgEqSet) {
            ourTrgEqSet.add(tEq);
            this.m_trgMap.put(tEq.getId(), tEq);
        }
    }

    protected void costruct(Set<EquivalenceClass> srcEq, Set<EquivalenceClass> trgEq, SimpleDictionary simpleDict) {
        HashMap<String, EquivalenceClass> srcMap = null;
        HashMap<String, EquivalenceClass> trgMap = null;
        if (srcEq != null) {
            srcMap = new HashMap<String, EquivalenceClass>();
            for (EquivalenceClass eq : srcEq) {
                for (String sWord : eq.getAllWords()) {
                    assert (!srcMap.containsKey(sWord));
                    srcMap.put(sWord, eq);
                }
            }
        }
        if (trgEq != null) {
            trgMap = new HashMap<String, EquivalenceClass>();
            for (EquivalenceClass eq : trgEq) {
                for (String tWord : eq.getAllWords()) {
                    assert (!trgMap.containsKey(tWord));
                    trgMap.put(tWord, eq);
                }
            }
        }
        for (String sDictWord : simpleDict.getAllSrc()) {
            EquivalenceClass sEq;
            if (srcMap == null) {
                sEq = new SimpleEquivalenceClass();
                sEq.init(sDictWord, false);
            } else {
                sEq = (EquivalenceClass)srcMap.get(sDictWord);
            }
            if (sEq == null) continue;
            for (String tDictWord : simpleDict.getTrg(sDictWord)) {
                EquivalenceClass tEq;
                if (trgMap == null) {
                    tEq = new SimpleEquivalenceClass();
                    tEq.init(tDictWord, false);
                } else {
                    tEq = (EquivalenceClass)trgMap.get(tDictWord);
                }
                if (tEq == null) continue;
                HashSet<EquivalenceClass> tEqSet = this.m_map.get(sEq);
                if (tEqSet == null) {
                    tEqSet = new HashSet();
                    this.m_map.put(sEq, tEqSet);
                }
                tEqSet.add(tEq);
                this.m_srcMap.put(sEq.getId(), sEq);
                this.m_trgMap.put(tEq.getId(), tEq);
            }
        }
    }

    public String getName() {
        return this.m_name;
    }

    public Set<EquivalenceClass> getAllSrc() {
        return new HashSet<EquivalenceClass>(this.m_srcMap.values());
    }

    public int size() {
        return this.m_map.size();
    }

    public Set<EquivalenceClass> getAllTrg() {
        return new HashSet<EquivalenceClass>(this.m_trgMap.values());
    }

    public Set<EquivalenceClass> translate(EquivalenceClass srcEq) {
        return this.m_map.get(srcEq);
    }

    public boolean containsSrc(EquivalenceClass eq) {
        return this.m_srcMap.containsKey(eq.getId());
    }

    public boolean containsTrg(EquivalenceClass eq) {
        return this.m_trgMap.containsKey(eq.getId());
    }

    public List<Context.ContextualItem> translateContext(EquivalenceClass eq) {
        Context oldContext = (Context)eq.getProperty(Context.class.getName());
        LinkedList<Context.ContextualItem> newCis = new LinkedList<Context.ContextualItem>();
        if (oldContext != null) {
            Collection<Context.ContextualItem> oldCis = oldContext.getContextualItems();
            for (Context.ContextualItem oldCi : oldCis) {
                HashSet<EquivalenceClass> translations;
                Long srcEqId = oldCi.getContextEqId();
                EquivalenceClass srcEq = this.m_srcMap.get(srcEqId);
                if (srcEq == null || (translations = this.m_map.get(srcEq)) == null) continue;
                for (EquivalenceClass trgEq : translations) {
                    newCis.add(new Context.ContextualItem(null, trgEq.getId(), oldCi.getCorpusCount(), oldCi.getContextCount()));
                }
            }
        }
        return newCis;
    }

    public String toString() {
        return "Dictionary [" + this.m_name + "] contains " + this.m_map.size() + " source language entries.";
    }
}

