/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ConfidenceChunker;
import com.aliasi.chunk.NBestChunker;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RescoringChunker<B extends NBestChunker>
implements NBestChunker,
ConfidenceChunker {
    final B mChunker;
    int mNumChunkingsRescored;

    public RescoringChunker(B chunker, int numChunkingsRescored) {
        this.mChunker = chunker;
        this.mNumChunkingsRescored = numChunkingsRescored;
    }

    public abstract double rescore(Chunking var1);

    public B baseChunker() {
        return this.mChunker;
    }

    public int numChunkingsRescored() {
        return this.mNumChunkingsRescored;
    }

    public void setNumChunkingsRescored(int numChunkingsRescored) {
        this.mNumChunkingsRescored = numChunkingsRescored;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        return this.firstBest(this.mChunker.nBest(cs, start, end, this.mNumChunkingsRescored));
    }

    @Override
    public Iterator<ScoredObject<Chunking>> nBest(char[] cs, int start, int end, int maxNBest) {
        return this.nBest(this.mChunker.nBest(cs, start, end, this.mNumChunkingsRescored), maxNBest);
    }

    @Override
    public Iterator<Chunk> nBestChunks(char[] cs, int start, int end, int maxNBest) {
        double totalScore = 0.0;
        HashMap<Chunk, Double> chunkToScore = new HashMap<Chunk, Double>();
        Iterator<ScoredObject<Chunking>> it = this.nBest(cs, start, end, this.mNumChunkingsRescored);
        while (it.hasNext()) {
            ScoredObject<Chunking> so = it.next();
            double score = Math.pow(2.0, so.score());
            totalScore += score;
            Chunking chunking = so.getObject();
            for (Chunk chunk : chunking.chunkSet()) {
                Chunk unscoredChunk = ChunkFactory.createChunk(chunk.start(), chunk.end(), chunk.type());
                Double currentScoreD = (Double)chunkToScore.get(chunk);
                double currentScore = currentScoreD == null ? 0.0 : currentScoreD;
                double nextScore = currentScore + score;
                chunkToScore.put(unscoredChunk, nextScore);
            }
        }
        BoundedPriorityQueue<Chunk> bpq = new BoundedPriorityQueue<Chunk>(ScoredObject.comparator(), maxNBest);
        for (Map.Entry entry : chunkToScore.entrySet()) {
            Chunk chunk = (Chunk)entry.getKey();
            double conditionalEstimate = (Double)entry.getValue() / totalScore;
            Chunk scored = ChunkFactory.createChunk(chunk.start(), chunk.end(), chunk.type(), conditionalEstimate);
            bpq.offer(scored);
        }
        return bpq.iterator();
    }

    private Chunking firstBest(Iterator<ScoredObject<Chunking>> nBestChunkingIt) {
        Chunking bestChunking = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        while (nBestChunkingIt.hasNext()) {
            ScoredObject<Chunking> scoredChunking = nBestChunkingIt.next();
            Chunking chunking = scoredChunking.getObject();
            double score = this.rescore(chunking);
            if (!(score > bestScore)) continue;
            bestScore = score;
            bestChunking = chunking;
        }
        return bestChunking;
    }

    private Iterator<ScoredObject<Chunking>> nBest(Iterator<ScoredObject<Chunking>> nBestChunkingIt, int maxNBest) {
        BoundedPriorityQueue<ScoredObject<Chunking>> queue = new BoundedPriorityQueue<ScoredObject<Chunking>>(ScoredObject.comparator(), maxNBest);
        while (nBestChunkingIt.hasNext()) {
            ScoredObject<Chunking> scoredChunking = nBestChunkingIt.next();
            Chunking chunking = scoredChunking.getObject();
            double score = this.rescore(chunking);
            queue.offer(new ScoredObject<Chunking>(chunking, score));
        }
        return queue.iterator();
    }
}

