/*
 * Decompiled with CFR 0.152.
 */
package tsg.parsingExp;

import java.io.File;
import java.io.PrintWriter;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import tsg.TSNode;
import tsg.corpora.Tiger2;
import util.FileUtil;
import util.UtilXml;

public class ParseTiger_old {
    public static File corpusXmlShort = Tiger2.TigerTBxmlShort;
    public static File corpusXml = Tiger2.TigerTBxml;
    public static File corpusPennShort = Tiger2.TigerTBPennShort;
    public static File corpusPenn = Tiger2.TigerTBPenn;
    public static String headLabel = "HD";
    public static int corpusSize = 50474;
    public static int corpusShortSize = 4;

    public static void tigerXmlToPenn(File inputFile, File outputFile, int size, boolean headMarks) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        Document dom = UtilXml.getDOM_xml(inputFile);
        Element docEle = dom.getDocumentElement();
        NodeList nl = docEle.getElementsByTagName("s");
        int i = 0;
        while (i < size) {
            Element s = (Element)nl.item(i);
            String id = s.getAttribute("id");
            TSNode TSNsentence = ParseTiger_old.parserSentence(s, headMarks);
            out.println(TSNsentence.toString(headMarks, false));
            ++i;
        }
        out.close();
    }

    private static TSNode parserSentence(Element s, boolean headMarks) {
        Hashtable<String, TSNode> idNode = new Hashtable<String, TSNode>();
        NodeList terminals = s.getElementsByTagName("t");
        int i = 0;
        while (i < terminals.getLength()) {
            Element t = (Element)terminals.item(i);
            String id = t.getAttribute("id");
            String word = t.getAttribute("word");
            String pos = t.getAttribute("pos");
            TSNode lexical = TSNode.TSNodeLexical(word);
            TSNode posNode = new TSNode(pos, new TSNode[]{lexical});
            idNode.put(id, posNode);
            ++i;
        }
        NodeList nodes = s.getElementsByTagName("nt");
        int i2 = 0;
        while (i2 < nodes.getLength()) {
            Element n = (Element)nodes.item(i2);
            String id = n.getAttribute("id");
            String cat = n.getAttribute("cat");
            NodeList edges = n.getElementsByTagName("edge");
            TSNode[] daughters = new TSNode[edges.getLength()];
            int j = 0;
            while (j < edges.getLength()) {
                String edgeLabel;
                Element e = (Element)edges.item(j);
                String idref = e.getAttribute("idref");
                daughters[j] = (TSNode)idNode.get(idref);
                if (headMarks && (edgeLabel = e.getAttribute("label")).equals(headLabel)) {
                    daughters[j].headMarked = true;
                }
                ++j;
            }
            TSNode catNode = new TSNode(cat, daughters);
            if (i2 == nodes.getLength() - 1) {
                return catNode;
            }
            idNode.put(id, catNode);
            ++i2;
        }
        return null;
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        NodeList nl = ele.getElementsByTagName(tagName);
        if (nl != null && nl.getLength() > 0) {
            Element el = (Element)nl.item(0);
            textVal = el.getFirstChild().getNodeValue();
        }
        return textVal;
    }

    public static void main(String[] args) {
        ParseTiger_old.tigerXmlToPenn(corpusXml, corpusPenn, corpusSize, true);
    }
}

