/*
 * Decompiled with CFR 0.152.
 */
package tsg.fragStats;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Scanner;
import org.apache.tools.bzip2.CBZip2InputStream;
import util.ArgumentReader;
import util.FileUtil;
import util.PrintProgress;

public class FragmentFileFilter {
    static boolean read2bytes = true;
    static int printProgressEvery = 100000;
    File fragmentFile;
    int threshold;
    PrintProgress progress;
    PrintWriter pw;

    public FragmentFileFilter(File fragmentFile, File outputFile, int threshold, boolean inputIsCompressed) throws Exception {
        this.fragmentFile = fragmentFile;
        this.threshold = threshold;
        this.pw = FileUtil.getPrintWriter(outputFile);
        this.progress = new PrintProgress("Reading fragments", printProgressEvery, 0);
        if (inputIsCompressed) {
            this.filterFragemntFileCompressed();
        } else {
            this.filterFragemntFile();
        }
        this.progress.end();
        this.pw.close();
    }

    private void analyzeNextLine(String line) throws Exception {
        this.progress.next();
        String[] lineSplit = line.split("\t");
        int freq = Integer.parseInt(lineSplit[1]);
        if (freq >= this.threshold) {
            this.pw.println(line);
        }
    }

    private void filterFragemntFile() throws Exception {
        Scanner scan = FileUtil.getScanner(this.fragmentFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            this.analyzeNextLine(line);
        }
        scan.close();
    }

    private void filterFragemntFileCompressed() throws Exception {
        String line;
        FileInputStream inputStream = new FileInputStream(this.fragmentFile);
        if (read2bytes) {
            inputStream.read();
            inputStream.read();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)inputStream), "UTF-8"));
        while ((line = reader.readLine()) != null) {
            this.analyzeNextLine(line);
        }
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        File fragmentFile = new File(args[0]);
        File outputFile = new File(args[1]);
        int threshold = ArgumentReader.readIntOption(args[2]);
        boolean inputIsCompressed = ArgumentReader.readBooleanOption(args[3]);
        new FragmentFileFilter(fragmentFile, outputFile, threshold, inputIsCompressed);
    }
}

