/*
 * Decompiled with CFR 0.152.
 */
package tsg.LTSG;

import java.util.PriorityQueue;
import tsg.LTSG.LexicalDerivation;
import tsg.TSNode;

public class LexDerivationQueue {
    PriorityQueue<LexicalDerivation> queue = new PriorityQueue();
    LexicalDerivation[][] subSideNBestTable;
    TSNode anchor;
    int combinations;
    int anchorIndex;
    double lexTreeProb;
    int[] subSideSizes;
    boolean[] accessMatrix;
    LexicalDerivation lastReturned;

    public LexDerivationQueue(LexicalDerivation[][] subSideNBestTable, TSNode anchor, int anchorIndex, double lexTreeProb) {
        this.subSideNBestTable = subSideNBestTable;
        this.anchor = anchor;
        this.anchorIndex = anchorIndex;
        this.lexTreeProb = lexTreeProb;
        this.subSideSizes = new int[subSideNBestTable.length];
        this.combinations = 1;
        int i = 0;
        while (i < subSideNBestTable.length) {
            this.subSideSizes[i] = subSideNBestTable[i].length;
            this.combinations *= subSideNBestTable[i].length;
            ++i;
        }
        this.accessMatrix = new boolean[this.combinations];
    }

    private int oneDimIndex(int[] indexes) {
        if (indexes.length > 2) {
            System.out.print("");
        }
        int uniIndex = indexes[0];
        int multFact = this.subSideSizes[0];
        int i = 1;
        while (i < indexes.length) {
            uniIndex += multFact * indexes[i];
            multFact *= this.subSideSizes[i];
            ++i;
        }
        return uniIndex;
    }

    private LexicalDerivation createNewLexicalDerivation(int[] indexes) {
        LexicalDerivation[] indexSubSiteDerivations = new LexicalDerivation[indexes.length];
        double logDerivationProb = this.lexTreeProb;
        int i = 0;
        while (i < indexes.length) {
            if (indexes[i] != -1) {
                logDerivationProb += this.subSideNBestTable[i][indexes[i]].logDerivationProb;
                indexSubSiteDerivations[i] = this.subSideNBestTable[i][indexes[i]];
            }
            ++i;
        }
        int[] indexCopy = new int[indexes.length];
        int i2 = 0;
        while (i2 < indexes.length) {
            indexCopy[i2] = indexes[i2];
            ++i2;
        }
        LexicalDerivation topQueueDerivation = new LexicalDerivation(this.anchor, this.anchorIndex, logDerivationProb, indexSubSiteDerivations, indexCopy);
        return topQueueDerivation;
    }

    public LexicalDerivation pollFirst() {
        int[] indexes = new int[this.subSideNBestTable.length];
        int i = 0;
        while (i < this.subSideNBestTable.length) {
            indexes[i] = this.subSideNBestTable[i] == null ? -1 : 0;
            ++i;
        }
        this.accessMatrix[0] = true;
        this.lastReturned = this.createNewLexicalDerivation(indexes);
        return this.lastReturned;
    }

    public LexicalDerivation addNeighboursAndPoll() {
        int[] lastExtractedIndexes = this.lastReturned.subSiteDerivationsIndexes;
        boolean noNeighboursAdded = true;
        int i = 0;
        while (i < this.subSideNBestTable.length) {
            if (lastExtractedIndexes[i] != -1 && lastExtractedIndexes[i] + 1 < this.subSideSizes[i]) {
                int n = i;
                lastExtractedIndexes[n] = lastExtractedIndexes[n] + 1;
                int oneDimIndex = this.oneDimIndex(lastExtractedIndexes);
                if (!this.accessMatrix[oneDimIndex]) {
                    noNeighboursAdded = false;
                    this.queue.add(this.createNewLexicalDerivation(lastExtractedIndexes));
                    this.accessMatrix[oneDimIndex] = true;
                }
                int n2 = i;
                lastExtractedIndexes[n2] = lastExtractedIndexes[n2] - 1;
            }
            ++i;
        }
        this.lastReturned = this.queue.poll();
        return this.lastReturned;
    }
}

