/*
 * Decompiled with CFR 0.152.
 */
package tsg.mb;

import java.util.ArrayList;
import tsg.Label;
import tsg.TSNodeLabel;
import tsg.mb.TreeMarkoBinarization;
import util.BoundedLinkedList;

public class TreeMarkoBinarizationRight_LC
extends TreeMarkoBinarization {
    @Override
    public TSNodeLabel performMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = TreeMarkoBinarizationRight_LC.performParentAnnotation(t);
        return this.performMarkoBinarizationRight(result);
    }

    @Override
    public TSNodeLabel undoMarkovBinarization(TSNodeLabel t) {
        TSNodeLabel result = this.undoMarkoBinarizationRight(t);
        return TreeMarkoBinarizationRight_LC.undoParentAnnotation(result);
    }

    private TSNodeLabel performMarkoBinarizationRight(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel binaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return binaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.performMarkoBinarizationRight(t.firstDaughter());
            binaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = binaryCopy;
            return binaryCopy;
        }
        BoundedLinkedList<String> lastSiblings = new BoundedLinkedList<String>(markH);
        String parentLabelString = t.label();
        TSNodeLabel previousLevel = binaryCopy;
        int i = 0;
        while (i < prole - 1) {
            TSNodeLabel d = t.daughters[i];
            lastSiblings.add(d.label());
            TSNodeLabel left = this.performMarkoBinarizationRight(d);
            Label rightLabel = TreeMarkoBinarization.buildArtificialLabel(parentLabelString, lastSiblings);
            TSNodeLabel right = new TSNodeLabel(rightLabel, t.isLexical);
            previousLevel.daughters = new TSNodeLabel[]{left, right};
            left.parent = previousLevel;
            right.parent = previousLevel;
            previousLevel = right;
            ++i;
        }
        TSNodeLabel onlyDaughter = this.performMarkoBinarizationRight(t.daughters[prole - 1]);
        previousLevel.daughters = new TSNodeLabel[]{onlyDaughter};
        onlyDaughter.parent = previousLevel;
        return binaryCopy;
    }

    private TSNodeLabel undoMarkoBinarizationRight(TSNodeLabel t) {
        int prole = t.prole();
        TSNodeLabel unbinaryCopy = new TSNodeLabel(t.label, t.isLexical);
        if (prole == 0) {
            return unbinaryCopy;
        }
        if (prole == 1) {
            TSNodeLabel onlyDaughter = this.undoMarkoBinarizationRight(t.firstDaughter());
            unbinaryCopy.daughters = new TSNodeLabel[]{onlyDaughter};
            onlyDaughter.parent = unbinaryCopy;
            return unbinaryCopy;
        }
        ArrayList<TSNodeLabel> newDaughters = new ArrayList<TSNodeLabel>();
        TSNodeLabel currentLevel = t;
        do {
            newDaughters.add(this.undoMarkoBinarizationRight(currentLevel.firstDaughter()));
        } while (TreeMarkoBinarizationRight_LC.isArtificialNode(currentLevel = currentLevel.lastDaughter()));
        int newProle = newDaughters.size();
        unbinaryCopy.daughters = new TSNodeLabel[newProle];
        int i = 0;
        for (TSNodeLabel d : newDaughters) {
            unbinaryCopy.daughters[i++] = d;
            d.parent = unbinaryCopy;
        }
        return unbinaryCopy;
    }

    @Override
    public String getDescription() {
        return "TreeMarkoBinarizationRight_LC";
    }

    public static void main(String[] args) throws Exception {
        markH = 1;
        markV = 1;
        TSNodeLabel t = new TSNodeLabel("(A B C D E)");
        TSNodeLabel[] tSNodeLabelArray = t.daughters;
        int n = t.daughters.length;
        int n2 = 0;
        while (n2 < n) {
            TSNodeLabel d = tSNodeLabelArray[n2];
            d.isLexical = false;
            ++n2;
        }
        System.out.println(t.toStringQtree());
        TreeMarkoBinarizationRight_LC tmb = new TreeMarkoBinarizationRight_LC();
        TSNodeLabel markoBinarizedTree = tmb.performMarkovBinarization(t);
        System.out.println(markoBinarizedTree.toStringQtree());
        System.out.println(markoBinarizedTree.checkParentDaughtersConsistency());
        System.out.println(markoBinarizedTree.checkOnlyAndAllTerminalsAreLexical());
        TSNodeLabel original = tmb.undoMarkovBinarization(markoBinarizedTree);
        System.out.println(original.toStringQtree());
        System.out.println(original.equals(t));
        System.out.println(original.checkParentDaughtersConsistency());
        System.out.println(original.checkOnlyAndAllTerminalsAreLexical());
    }
}

