#! bin/bash
set -e

task_name=rte # (sst2, rte, qqp, qnli, mnli, mnli_mm))
method=gradient_low # for file name
local_rank=1 #cuda_num
ver=2  # 0,1,2 # as a random seed
samples=1000 # (number of sample in low resources)
train_batch_size=16
eval_batch_size=4 
num_train_epochs=100
patience=5 #patience for early stopping
lr=2e-5 


mkdir -p results/${task_name}/${method}/low_${samples}/ver_${ver}

result_name=results/${task_name}/${method}/low_${samples}/ver_${ver}.txt
train_dir=data/clean/bert-base-uncased/${task_name}_train
eval_dir=data/clean/bert-base-uncased/${task_name}_test
attacked_dir=data/attacked/bert-base-uncased/${task_name}
bert_model=bert-base-uncased
output_dir=results/${task_name}/${method}/low_${samples}/ver_${ver}





python3 -u run_im_bert.py >${result_name}\
    --train_dir $train_dir \
    --eval_dir $eval_dir \
    --train_batch_size $train_batch_size \
    --eval_batch_size $eval_batch_size \
    --attacked_dir $attacked_dir \
    --bert_model $bert_model \
    --task_name $task_name \
    --output_dir $output_dir \
    --num_train_epochs $num_train_epochs\
    --learning_rate $lr\
    --max_seq_length $max_seq_length \
    --local_rank $local_rank \
    --early_stop $patience\
    --num_samples $samples\  # If you want to run with full data, erase it
    --sample_seed $ver\ # The random seed for data random sampling in low resource situations
    --print_params \
    --do_train \
    --do_eval \
