/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.swing;

import java.awt.event.MouseEvent;
import javax.swing.JList;
import javax.swing.ListModel;

public class TooltipJList
extends JList {
    private static int PROBLEM_LINE_LENGTH = 80;

    public TooltipJList() {
    }

    public TooltipJList(ListModel model) {
        this(model, PROBLEM_LINE_LENGTH);
    }

    public TooltipJList(ListModel model, int lineWrapLength) {
        super(model);
        PROBLEM_LINE_LENGTH = lineWrapLength;
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        int index = this.locationToIndex(evt.getPoint());
        if (-1 < index) {
            StringBuilder s = new StringBuilder();
            String text = this.getModel().getElementAt(index).toString();
            s.append("<html>");
            String textLeft = text;
            boolean isFirstLine = true;
            while (textLeft.length() > 0) {
                String curLine = "";
                if (textLeft.length() > PROBLEM_LINE_LENGTH) {
                    curLine = textLeft.substring(0, PROBLEM_LINE_LENGTH);
                    textLeft = textLeft.substring(PROBLEM_LINE_LENGTH, textLeft.length());
                    while (curLine.charAt(curLine.length() - 1) != ' ' && textLeft.length() > 0) {
                        curLine = curLine + textLeft.substring(0, 1);
                        textLeft = textLeft.substring(1, textLeft.length());
                    }
                } else {
                    curLine = textLeft;
                    textLeft = "";
                }
                if (!isFirstLine) {
                    s.append("<br>");
                }
                s.append(curLine);
                if (!isFirstLine) {
                    s.append("</br>");
                    continue;
                }
                isFirstLine = false;
            }
            s.append("</html>");
            return s.toString();
        }
        return null;
    }
}

