### Installation

To run our training scripts, create a virtual environment and install the dependencies first.

```bash
conda create -n silkie python=3.10  && conda activate silkie
pip install -r requirements.txt
```

### Training

Our training scripts support both single-node and multi-node training.
We provide a `launch_dpo.py` script that handles both cases. If you want to launch a job locally, you can use:

```bash
python launch_dpo.py --config dpo_config/example.yaml --working $WORKING_DIR
```

If you want to launch a job on a Slurm cluster, specify `GPUS_PER_NODE` in `launch_dpo.py` and run:

```bash
python launch_dpo.py --config dpo_config/example.yaml --working $WORKING_DIR --gpus $NUM_GPUS
```
