"""
Inference Focused Utility Functions To Reduce Code Duplication
"""

import os


def _handle_mismatched_length(outputs, prompts):

    # Extend or truncate outputs to match the length of prompts
    if len(outputs) < len(prompts):
        print("Error: Handling Mismatched Output Length")
        outputs.extend(
            [" "] * (len(prompts) - len(outputs))
        )  # Using empty strings as default values
    elif len(outputs) > len(prompts):
        print("Error: Handling Mismatched Output Length")
        outputs = outputs[: len(prompts)]
    return outputs


def run_inference(llm, sampling_params, prompts):
    outputs = llm.generate(prompts, sampling_params)
    outputs = [i.outputs[0].text for i in outputs]
    outputs = _handle_mismatched_length(outputs, prompts)
    return outputs


def read_text_file(file_path: str) -> str:
    if not os.path.exists(file_path):
        raise FileNotFoundError(f"File {file_path} not found")
    with open(file_path, "r") as f:
        content = f.read()
    return content
