theory question_13_10

imports Main

begin

typedecl entity
typedecl event

consts
  Liquid :: "entity ⇒ bool"
  Water :: "entity ⇒ bool"
  Gas :: "entity ⇒ bool"
  Heating :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ChangeState :: "event ⇒ bool"
  AddEnergy :: "event ⇒ bool"
  Form :: "entity ⇒ state ⇒ bool"
  StateOfMatter :: "entity ⇒ bool"
  Example :: "event ⇒ event ⇒ bool"
  Disappears :: "event ⇒ bool"
  RemainingState :: "event ⇒ bool"

(* Explanation 1: Heating a liquid, specifically water, results in a change of state to a gas by adding heat energy. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Liquid x ∧ Water y ∧ Gas z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ ChangeState e2 ∧ Patient e2 z ∧ AddEnergy e1 ∧ Form z g ∧ Form y l"

(* Explanation 2: Heating refers to the action of adding heat. *)
axiomatization where
  explanation_2: "∀e x. Heating e ⟶ Action e ∧ AddEnergy e ∧ Agent e x"

(* Explanation 3: Water is a kind of liquid. *)
axiomatization where
  explanation_3: "∀x. Water x ⟶ Liquid x"

(* Explanation 4: If water disappears from a container during heating, it probably evaporated, which is a change of state to a gas. *)
axiomatization where
  explanation_4: "∀x y e1 e2. Container x ∧ Water y ∧ Disappears e1 ∧ Agent e1 y ∧ Patient e1 x ⟶ Evaporated e2 ∧ Patient e2 y ∧ ChangeState e2 ∧ Patient e2 g"

(* Explanation 5: Evaporation is a change of state from a liquid to a gas due to the addition of heat. *)
axiomatization where
  explanation_5: "∀e x y. Evaporation e ⟶ ChangeState e ∧ Patient e x ∧ Form x l ∧ Form y g ∧ AddEnergy e"

(* Explanation 6: Liquid and gas are kinds of states of matter. *)
axiomatization where
  explanation_6a: "∀x. Liquid x ⟶ StateOfMatter x ∧ Form x l"
  explanation_6b: "∀x. Gas x ⟶ StateOfMatter x ∧ Form x g"

(* Explanation 7: A container of water being heated and evaporated is an example of matter changing state. *)
axiomatization where
  explanation_7: "∀x y e1 e2. Container x ∧ Water y ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Evaporated e2 ∧ Patient e2 y ⟶ Example e1 e2 ∧ ChangeState e2 ∧ Patient e2 m"

(* Explanation 8: After heating water until it has all evaporated, the remaining state of matter is a gas. *)
axiomatization where
  explanation_8: "∀x y e1 e2. Water x ∧ Heating e1 ∧ Agent e1 x ∧ Evaporated e2 ∧ Patient e2 x ⟶ RemainingState e1 ∧ Patient e1 g ∧ ChangeState e2 ∧ Patient e2 x"

theorem hypothesis:
  assumes asm: "Pan x ∧ Water y ∧ Matter z ∧ Heating e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ChangeState e2 ∧ Patient e2 z"
  (* Hypothesis: Heating a pan of water until the water is all gone is an example of matter changing state. *)
  shows "∃e1 e2. Example e1 e2 ∧ ChangeState e2 ∧ Patient e2 m"
proof -
  from asm have water_is_liquid: "Water y" by simp
  have liquid_is_state_of_matter: "Liquid x ⟶ StateOfMatter x" using explanation_6a by simp
  have water_is_state_of_matter: "StateOfMatter y" using water_is_liquid liquid_is_state_of_matter by blast
  have heating_adds_energy: "AddEnergy e1" using asm explanation_2 by blast
  have heating_is_action: "Action e1" using asm explanation_2 by blast
  have patient_is_water: "Patient e1 y" using asm by simp
  have change_state: "ChangeState e2" using asm by simp
  have patient_is_z: "Patient e2 z" using asm by simp
  have z_is_state_of_matter: "StateOfMatter z" using patient_is_z by simp
  have water_evaporated: "Evaporated e3 ∧ Patient e3 y ∧ ChangeState e3 ∧ Patient e3 g" if "Disappears e1" "Agent e1 y" "Patient e1 x" for e3
    using asm explanation_4 by metis
  have water_evaporated: "Evaporated e3 ∧ Patient e3 y ∧ ChangeState e3 ∧ Patient e3 g"
    using asm water_evaporated by (metis patient_is_water)
  have e1_is_heating: "Example e1 e3" using asm water_evaporated explanation_7 by blast
  have remaining_state_is_gas: "RemainingState e1 ∧ Patient e1 g ∧ ChangeState e3 ∧ Patient e3 y"
    using asm water_evaporated explanation_8 by blast
  have patient_is_matter: "Patient e3 m" using water_is_state_of_matter z_is_state_of_matter remaining_state_is_gas by blast
  have e1_e3_is_example: "Example e1 e3" using e1_is_heating by simp
  have change_state_is_e3: "ChangeState e3" using remaining_state_is_gas by simp
  have patient_is_matter_e3: "Patient e3 m" using patient_is_matter by simp
  show ?thesis using e1_e3_is_example change_state_is_e3 patient_is_matter_e3 by blast
qed

end
