theory question_27_1
imports Main

begin

typedecl entity
typedecl event

consts
  WaterVapor :: "entity ⇒ bool"
  Cooling :: "event ⇒ bool"
  Condense :: "event ⇒ bool"
  LiquidForm :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Water vapor cooling causes water vapor to condense into liquid form. *)
axiomatization where
  explanation_1: "∀x e. WaterVapor x ∧ Cooling e ∧ Agent e x ⟶ (∃e'. Condense e' ∧ Agent e' x ∧ LiquidForm x)"

theorem hypothesis:
  assumes asm: "WaterVapor x ∧ Cooling e ∧ Agent e x"
  (* Hypothesis: Water vapor chilling causes water vapor to condense. *)
  shows "∃e'. Condense e' ∧ Agent e' x ∧ LiquidForm x"
proof -
  from asm have "WaterVapor x ∧ Cooling e ∧ Agent e x" by simp
  then have "Condense e' ∧ Agent e' x ∧ LiquidForm x" using explanation_1 by blast
  then show ?thesis using asm by simp
qed

end
