theory question_93_9
imports Main

begin

typedecl entity
typedecl event

consts
  ChaseAway :: "event ⇒ bool"
  Chaser :: "event ⇒ entity ⇒ bool"
  ChasedEntity :: "event ⇒ entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"

(* Explanation 1: ∀e. ChaseAway(e) ⟶ (∃x. Chaser(e, x) ∧ ∃y. ChasedEntity(e, y) ∧ Animals(y)) *)
axiomatization where
  explanation_1: "∀e. ChaseAway e ⟶ (∃x y. Chaser e x ∧ ChasedEntity e y ∧ Animals y)"

theorem hypothesis:
  (* Premise: none *)
  assumes asm: "true"
  (* Hypothesis: ∃x. Woman(x) ∧ ∃y. Animals(y) *)
  shows "∃x y. Woman x ∧ Animals y"
proof -
  from asm have "true" by blast
  then have "∃x. Woman x" by (rule exI)
  then obtain w where "Woman w" by blast
  then have "∃y. Animals y" using explanation_3 by blast
  then obtain a where "Animals a" by blast
  then show ?thesis using `Woman w` `Animals a` by blast
qed

end
