theory question_79_1
imports Main

begin

typedecl entity
typedecl event

consts
  People :: "entity ⇒ bool"
  BirthdayCake :: "entity ⇒ bool"
  Preparation :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Cut :: "event ⇒ bool"
  GotReady :: "event ⇒ bool"

(* Explanation: People getting ready to cut a birthday cake. *)
axiomatization where
  explanation: "∃x e. People x ∧ Preparation e ∧ Agent e x ∧ ∃y. (BirthdayCake y ∧ Patient e y)"

theorem hypothesis:
  (* Premise: People getting ready to cut a birthday cake. *)
  assumes asm: "People x ∧ Preparation e ∧ Agent e x ∧  BirthdayCake y ∧ Patient e y  "
  (* Hypothesis: They got ready to cut the cake. *)
  shows "∃x e. People x ∧ BirthdayCake y ∧ Preparation e ∧ Agent e x ∧ Patient e y ∧ Cut e' ∧ GotReady e ∧ Agent e x"
proof -
  from asm have "Preparation e ∧ Agent e x ∧  BirthdayCake y ∧ Patient e y" by blast
  then have "∃e. Preparation e ∧ Agent e x ∧ ∃y. (BirthdayCake y ∧ Patient e y)" using explanation by blast
  then have "∃e. Preparation e ∧ Agent e x ∧ ∃y. (BirthdayCake y ∧ Patient e y) ∧ Cut e' ∧ GotReady e" by (rule impI)
  then have "∃x e. People x ∧ BirthdayCake y ∧ Preparation e ∧ Agent e x ∧ Patient e y ∧ Cut e' ∧ GotReady e ∧ Agent e x" by (rule impI)
  then show ?thesis by blast
qed

end
