theory question_65_0
imports Main
begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ComesOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Circuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  WillFlow :: "event ⇒ bool"

(* Explanation 1: when electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟹ (ComesOn e2 ∧ Agent e2 y)"

(* Explanation 2: when a switch in a simple series circuit is closed, electricity will flow through the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Switch x ∧ SimpleSeriesCircuit y ∧ Circuit z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟹ (WillFlow e2 ∧ Agent e2 x ∧ Patient e2 z)"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  {
    assume "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
    then obtain e1 where "WillFlow e1 ∧ Agent e1 x ∧ Patient e1 z"
      using explanation_2 by blast
    then obtain y where "Circuit y ∧ Patient e1 y"
      by auto
    then obtain e2 where "Flows e2 ∧ Agent e2 x ∧ Patient e2 y"
      using explanation_2 by blast
    then obtain z where "LightBulb z ∧ Patient e2 z"
      by auto
    then obtain e3 where "ComesOn e3 ∧ Agent e3 z"
      using explanation_1 by blast
    then have "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
      using that by blast
  }
  then show ?thesis using asm by blast
qed

end
