theory question_1_5
imports Main

begin

typedecl entity
typedecl event

consts
  ScientificGuess :: "entity ⇒ bool"
  CauseAndEffect :: "event ⇒ bool"
  About :: "entity ⇒ event ⇒ bool"
  Called :: "entity ⇒ entity ⇒ bool"
  Hypothesis :: "entity ⇒ bool"
  SpecificTypeOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: A scientific guess about the cause and effect of an event is called a hypothesis. *)
axiomatization where
  explanation_1: "∀x e. ScientificGuess x ∧ CauseAndEffect e ∧ About x e ⟶ (∃h. Hypothesis h ∧ Called x h)"

(* Explanation 2: A hypothesis is a specific type of scientific guess. *)
axiomatization where
  explanation_2: "∀x h. Hypothesis h ⟶ SpecificTypeOf h x"

theorem hypothesis:
  assumes asm: "ScientificGuess x ∧ CauseAndEffect e ∧ About x e"
  (* Hypothesis: A scientific guess about the cause and effect of an event is called a hypothesis. *)
  shows "∃h. Hypothesis h ∧ Called x h"
proof -
  from asm have "ScientificGuess x ∧ CauseAndEffect e ∧ About x e" by simp
  then obtain h where h: "Hypothesis h ∧ Called x h" using explanation_1 by blast
  show ?thesis using h by blast
qed

end
