theory question_63_0

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  FormedBy :: "entity ⇒ event ⇒ bool"
  Commonest :: "entity ⇒ bool"
  Sandstone :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed by deposition. *)
axiomatization where
  explanation_1: "∀x e. SedimentaryRocks x ⟶ (∃e. Deposition e ∧ FormedBy x e)"

(* Explanation 2: Sedimentary Rocks One of the commonest sedimentary rocks is sandstone. *)
axiomatization where
  explanation_2: "∃x. SedimentaryRocks x ∧ Commonest x ⟷ Sandstone x"

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition e ∧ FormedBy x e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "FormedBy x e" by simp
  then obtain e' where e': "Deposition e' ∧ FormedBy x e'" using explanation_1 by blast
  then have "SedimentaryRocks x" by blast
  then obtain x' where x': "SedimentaryRocks x' ∧ Commonest x' ⟷ Sandstone x'" using explanation_2 by blast
  then have "Sandstone x" using x' by blast
  show ?thesis using asm e' x' by blast
qed

end
