theory question_2_0

imports Main

begin

typedecl entity
typedecl event

consts
  MarineBiomes :: "entity ⇒ bool"
  InSaltWater :: "entity ⇒ bool"
  Ocean :: "entity ⇒ bool"
  Animal :: "entity ⇒ bool"
  SeaTigers :: "entity ⇒ bool"
  LivesIn :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Marine biomes are found in the salt water of the ocean. *)
axiomatization where
  explanation_1: "∀x. MarineBiomes x ⟶ InSaltWater x ∧ Ocean x"

(* Explanation 2: Another animal that lives within the Marine Biome is a sea tiger. *)
axiomatization where
  explanation_2: "∃x y. Animal x ∧ SeaTigers y ∧ MarineBiomes x ∧ LivesIn y x"

theorem hypothesis:
  assumes asm: "SeaTigers x"
  (* Hypothesis: Sea tigers are found in the salt water of the ocean. *)
  shows "InSaltWater x ∧ Ocean x"
proof -
  have "SeaTigers x" by fact
  then obtain y where "Animal y ∧ MarineBiomes y ∧ LivesIn x y" using explanation_2 by blast
  then have "MarineBiomes y" by simp
  then have "InSaltWater y ∧ Ocean y" using explanation_1 by blast
  then have "LivesIn x y ⟹ InSaltWater x ∧ Ocean x" by blast
  then show "InSaltWater x ∧ Ocean x" using asm by blast
qed

end
