theory question_46_9
imports Main

begin
typedecl entity
typedecl event

consts
  Boy :: "entity ⇒ bool"
  Fruit :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  StreetVendor :: "entity ⇒ bool"
  StreetCart :: "entity ⇒ bool"
  Location :: "entity ⇒ bool"
  Selling :: "event ⇒ bool"
  At :: "event ⇒ entity ⇒ bool"
  OrangeShirt :: "entity ⇒ bool"

(* Explanation 1: A boy who sells fruit is a street vendor. *)
axiomatization where
  explanation_1: "∃x y e. Boy x ∧ Fruit y ∧ Sells e ∧ Agent e x ∧ Patient e y ⟶ StreetVendor x"

(* Explanation 2: A street cart is a location where selling occurs. *)
axiomatization where
  explanation_2: "∀x. StreetCart x ⟶ Location x ∧ [∃e y z. Selling e ∧ Agent e z ∧ Patient e y ∧ At e x]"

theorem hypothesis:
  (* Premise: A boy in an orange shirt sells fruit from a street cart. *)
  assumes asm: "Boy x ∧ OrangeShirt x ∧ Fruit y ∧ StreetCart z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ From e z"
  (* Hypothesis: A boy is a street vendor. *)
  shows "∃x. Boy x ∧ StreetVendor x"
proof -
  from asm have "Boy x ∧ Fruit y ∧ Sells e ∧ Agent e x ∧ Patient e y" by blast
  then have "StreetVendor x" using explanation_1 by blast
  then show ?thesis using asm `Boy x` `StreetVendor x` by blast
qed

end
