theory question_85_0

imports Main

begin

typedecl entity
typedecl event

consts
  Flowing :: "entity ⇒ bool"
  Motion :: "entity ⇒ bool"
  Kind :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Roger :: "entity ⇒ bool"
  Pour :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  PileOfSand :: "entity ⇒ bool"

(* Explanation 1: flowing is a kind of motion. *)
axiomatization where
  explanation_1: "∀x y e. Flowing x ∧ Motion y ∧ Kind e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: roger poured water over a pile of sand. *)
axiomatization where
  explanation_2: "∃x y z e. Roger x ∧ Pour y ∧ Water z ∧ PileOfSand e ∧ Agent e x ∧ Patient e y"

(* Premise 1: roger poured water over a pile of sand. *)
axiomatization where
  premise_1: "∃x y z e. Roger x ∧ Pour y ∧ Water z ∧ PileOfSand e ∧ Agent e x ∧ Patient e y"

(* Premise 2: some of the sand washed away. *)
axiomatization where
  premise_2: "∃x y z e. Sand x ∧ WashAway y ∧ Some z ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: ""
    premise_1
    premise_2
  shows ""
    flowing_is_kind_of_motion: "∀x y e. Flowing x ∧ Motion y ∧ Kind e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Flowing x" by simp
  then obtain e1 where e1: "Kind e1 ∧ Agent e1 x ∧ Patient e1 y" using explanation_1 by blast
  then have "Motion y" using explanation_6 by blast
  then have "River z" using explanation_10 by blast
  then have "Erosion e2" using explanation_5 by blast
  then have "Weathering e3" using explanation_9 by blast
  then have "Sand y" using explanation_3 by blast
  then have "Soil y" using explanation_7 by blast
  then have "Washing away e4" using explanation_12 by blast
  then show "flowing_is_kind_of_motion" by simp
qed

end
