theory question_81_2

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Suddenly :: "entity ⇒ bool"
  Smaller :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Gets :: "event ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Process :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Happens :: "event ⇒ bool"
  Trigger :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller. *)
axiomatization where
  explanation_1: "∀x y e1 e2. BottleneckEffect x ∧ Population y ∧ Suddenly y ∧ Smaller y ∧ Occurs e1 ∧ Agent e1 x ⟶ Gets e2 ∧ Agent e2 y"

(* Explanation 2: External migration is a process that can cause a population to suddenly get much smaller. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. ExternalMigration x ∧ Process x ∧ Population y ∧ Suddenly y ∧ Smaller y ∧ Cause e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Gets e2 ∧ Agent e2 y"

(* Explanation 3: When external migration happens, it can trigger the bottleneck effect in the population. *)
axiomatization where
  explanation_3: "∀x y z e1 e2. ExternalMigration x ∧ Happens e1 ∧ Agent e1 x ⟶ (BottleneckEffect y ∧ Population z ∧ Trigger e2 ∧ Agent e2 y ∧ Patient e2 z)"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  then obtain e2 where e2: "Gets e2 ∧ Agent e2 y" using explanation_2 by blast
  then obtain e3 where e3: "Trigger e3 ∧ Agent e3 x ∧ Patient e3 y" using explanation_3 by blast
  have conclusion: "Occurs e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 e3 by simp
  show ?thesis using asm conclusion `ExternalMigration y` by blast
qed

end
