theory question_88_0

imports Main

begin
typedecl entity
typedecl event

consts
  Skills :: "entity ⇒ bool"
  Flip :: "entity ⇒ bool"
  Displaying :: "event ⇒ bool"
  Does :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Gymnast :: "entity ⇒ bool"
  Displays :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Flooring :: "entity ⇒ bool"
  Blue :: "entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Displaying skills with a flip is a rephrasing of "does a flip." *)
axiomatization where
  explanation_1: "∀x y e1 e2. Skills x ∧ Flip x ∧ Displaying e1 ∧ Patient e1 x ⟷ Does e2 ∧ Patient e2 x"

theorem hypothesis:
  (* Premise: Gymnast does a flip on blue flooring. *)
  assumes asm: "Gymnast x ∧ Flip y ∧ Flooring z ∧ Blue z ∧ Does e ∧ Agent e x ∧ Patient e y ∧ On e z"
  (* Hypothesis: A gymnast displays their skills with a flip *)
  shows "∃x y e. Gymnast x ∧ Skills y ∧ Flip y ∧ Displays e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "Gymnast x ∧ Flip y ∧ Does e ∧ Agent e x ∧ Patient e y" by blast
  then have "Gymnast x ∧ Skills y ∧ Flip y ∧ Displays e ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  then show ?thesis using asm by blast
qed

end
