theory question_72_0
imports Main

begin

typedecl entity
typedecl event

consts
  Friction :: "entity ⇒ bool"
  Objects :: "entity ⇒ entity ⇒ bool"
  SurfacesTouching :: "entity ⇒ entity ⇒ bool"
  Motion :: "event ⇒ bool"
  Counter :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  ResponsibleFor :: "event ⇒ event ⇒ bool"
  Cause :: "event ⇒ bool"
  Stop :: "entity ⇒ bool"
  Wagon :: "entity ⇒ bool"
  Acting :: "event ⇒ bool"
  Child :: "entity ⇒ bool"
  Hill :: "entity ⇒ bool"
  Rides :: "event ⇒ bool"
  Down :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: friction acts to counter the motion of two objects when their surfaces are touching. *)
axiomatization where
  explanation_1: "∀x y z e. Friction x ∧ Objects y z ∧ SurfacesTouching y z ∧ Motion e ∧ Counter e ∧ Agent e x ∧ Patient e y ∧ Patient e z"

(* Explanation 2: a surface is a part of an object. *)
axiomatization where
  explanation_2: "∀x y. SurfacesTouching x y ⟶ PartOf x y"

(* Explanation 3: a wagon is a kind of vehicle. *)
axiomatization where
  explanation_3: "∀x. Wagon x ⟶ Vehicle x"

(* Explanation 4: counter means reduce; stop; resist. *)
axiomatization where
  explanation_4: "∀x y. Counter x ⟷ (Reduce y ∨ Stop y ∨ Resist y)"

(* Explanation 5: riding something is to move that thing over a surface. *)
axiomatization where
  explanation_5: "∀x y z e. Rides x ∧ Objects y z ∧ Move e ∧ Agent e x ∧ Patient e y ∧ OverSurface y z"

(* Explanation 6: riding is a kind of motion. *)
axiomatization where
  explanation_6: "∀x. Rides x ⟶ Motion x"

(* Explanation 7: humans ride vehicles. *)
axiomatization where
  explanation_7: "∀x y. Child x ∧ Vehicle y ⟶ Rides x y"

(* Explanation 8: a child is a kind of young human. *)
axiomatization where
  explanation_8: "∀x. Child x ⟶ YoungHuman x"

(* Explanation 9: if one surface is moved against; moved over; moved down another surface then those surfaces are touching. *)
axiomatization where
  explanation_9: "∀x y z e. SurfacesTouching x y ∧ SurfacesTouching x z ∧ SurfacesTouching y z ∧ Moved e ∧ Against e x y ∧ Over e x z ∧ Down e x z ⟶ Touching y z"

(* Explanation 10: motion; movement means moving; to move. *)
axiomatization where
  explanation_10: "∀x y. Motion x ∧ Movement y ⟶ (Moving x ∨ Move y)"

(* Explanation 11: a vehicle is a kind of object. *)
axiomatization where
  explanation_11: "∀x. Vehicle x ⟶ Object x"

(* Explanation 12: friction causes the speed of an object to decrease. *)
axiomatization where
  explanation_12: "∀x y e. Friction x ∧ Speed y ∧ Object e ∧ Cause e ∧ Agent e x ∧ Patient e y ∧ Decrease y"

(* Explanation 13: stop; stopped means zero; 0; no speed. *)
axiomatization where
  explanation_13: "∀x y. Stop x ∧ Stopped y ⟶ (Zero y ∨ NoSpeed y)"

theorem hypothesis:
  (* Premise: a child rides a wagon down a hill. *)
  assumes asm: "Child x ∧ Wagon y ∧ Hill z ∧ Rides e ∧ Agent e x ∧ Patient e y ∧ Down e z"
  (* Hypothesis: Friction acting on the wagon is responsible for causing the wagon to stop. *)
  shows "∃x y e1 e2. Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ResponsibleFor e1 e2 ∧ Cause e2 ∧ Patient e2 y ∧ Stop y"
proof -
  from asm have "Rides e" by simp
  then have "Motion e" using explanation_6 by blast
  from asm have "Stop z" by simp
  then obtain x e1 e2 where "Friction x ∧ Wagon y ∧ Acting e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ResponsibleFor e1 e2 ∧ Cause e2 ∧ Patient e2 y ∧ Stop y" using explanation_1 explanation_12 by blast
  then show ?thesis using `Friction x` `Wagon y` `Acting e1` `Agent e1 x` `Patient e1 y` `ResponsibleFor e1 e2` `Cause e2` `Patient e2 y` by blast
qed

end
