theory question_98_0
imports Main

begin

typedecl entity
typedecl event

consts
  Egg :: "entity ⇒ bool"
  Warmth :: "event ⇒ bool"
  Survive :: "event ⇒ bool"
  BodyWarmth :: "event ⇒ bool"
  Incubate :: "event ⇒ bool"

(* Explanation 1: an egg requires warmth to survive *)
axiomatization where
  explanation_1: "∀x e. Egg x ∧ Warmth e ⟶ Survive e"

(* Explanation 2: Eggs depend upon body warmth to incubate. *)
axiomatization where
  explanation_2: "∀x e. Egg x ∧ BodyWarmth e ⟶ Incubate e"

theorem hypothesis:
  assumes asm: "Egg x"
  (* Hypothesis: Eggs need to incubate to survive. *)
  shows "∃x e. Egg x ∧ Incubate e ∧ Survive e"
proof -
  from asm have "Egg x" by simp
  then obtain e where e: "BodyWarmth e ∧ Incubate e" using explanation_2 by blast
  then have "Survive e" using explanation_1 `Egg x` by blast
  have conclusion: "BodyWarmth e ∧ Incubate e" using e by simp
  show ?thesis using asm conclusion `Survive e` by blast
qed

end
