theory question_81_3

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  BottleneckEffect :: "entity ⇒ bool"
  Trigger :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Triggered :: "event ⇒ bool"

(* Explanation 1: External migration can trigger the bottleneck effect. *)
axiomatization where
  explanation_1: "∀e x y. ExternalMigration x ∧ BottleneckEffect y ⟶ Trigger e ∧ Agent e x ∧ Patient e y"

(* Explanation 2: The bottleneck effect can be triggered by external migration. *)
axiomatization where
  explanation_2: "∀e x y. BottleneckEffect x ∧ ExternalMigration y ⟶ Triggered e ∧ Agent e y ∧ Patient e x"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e x y. BottleneckEffect x ∧ ExternalMigration y ∧ Occur e ∧ Agent e y ∧ Patient e x"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e where e: "Trigger e ∧ Agent e y ∧ Patient e x" using explanation_1 by blast
  then have "Triggered e" using explanation_2 by blast
  have conclusion: "Trigger e ∧ Agent e y ∧ Patient e x" using e by simp
  show ?thesis using asm conclusion `Triggered e` by blast
qed

end
