theory question_65_1
imports Main

begin
typedecl entity
typedecl event

consts
  Person :: "entity ⇒ bool"
  Alone :: "event ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  Field :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  Green :: "entity ⇒ bool"
  Lying :: "event ⇒ bool"
  Large :: "entity ⇒ bool"

(* Explanation 1: One person denotes a person alone. *)
axiomatization where
  explanation_1: "∀x e. Person x ∧ Alone e ⟶ In x e"

(* Explanation 2: A field outdoors is typically green. *)
axiomatization where
  explanation_2: "∀x. Field x ∧ Outdoors x ⟶ Green x"

theorem hypothesis:
  (* Premise: There is one person lying in a large, green field. *)
  assumes asm: "Person x ∧ Lying e ∧ Field y ∧ Large y ∧ Green y ∧ In x y"
  (* Hypothesis: There is a person alone in a field outdoors. *)
  shows "∃x y e. Person x ∧ Alone e ∧ Field y ∧ Outdoors y ∧ In x y"
proof -
  from asm have "Person x ∧ Lying e" by blast
  then have "Alone e" using explanation_1 by blast
  then have "Field y ∧ Outdoors y" using asm explanation_2 by blast
  then show ?thesis using `Person x` `Alone e` `Field y` `Outdoors y` by blast
qed

end
