﻿using System.Collections.Generic;
using System.Linq;

namespace SpreadsheetLLM.Heuristic
{
    internal partial class TableDetectionHybrid
    {
        public List<Boundary> HybridCombine(SheetMap inputSheet, List<Boundary> heuResults, List<Boundary> mlResults)
        {
            _sheet = inputSheet;

            _logs.Add($"HybridCombine running on {_boxes.Count} boxes");

            var appendBoxes = heuResults.Where(box =>
                _sheet.sumContentExist.SubmatrixSum(box) >= 8 &&
                !mlResults.Any(box2 => Utils.isOverlap(box2, box)));
            Utils.AppendTheseCandidates(appendBoxes, mlResults);
            _boxes = mlResults;

            // refine the clarity of Boudary lines 
            SparseBoundariesTrim2();

            CutHeaderFormatFilter();

            ////AddCompactRegionGrowth2(); // Xiao: Remove this logic for better accuracy

            return _boxes;
        }

        private void SparseBoundariesTrim2()
        {
            // for four directions, skip the sparse edges
            var removedBoxes = new HashSet<Boundary>();
            var appendBoxes = new HashSet<Boundary>();

            foreach (var box in _boxes)
            {
                var (top, bottom, left, right) = (box.top, box.bottom, box.left, box.right);
                bool markChange = true;
                while (markChange && left < right && top < bottom)
                {
                    markChange = false;

                    // change newBox when empty row found
                    // left
                    while (left > 0 && left < right && _sheet.sumContentExist.SubmatrixSum(new Boundary(top, bottom, left, left)) == 0)
                    {
                        left++;
                        markChange = true;
                    }

                    // right
                    while (right <= _sheet.Width && right > left && _sheet.sumContentExist.SubmatrixSum(new Boundary(top, bottom, right, right)) == 0)
                    {
                        right--;
                        markChange = true;
                    }

                    // up
                    while (top > 0 && top < bottom && _sheet.sumContentExist.SubmatrixSum(new Boundary(top, top, left, right)) == 0)
                    {
                        top++;
                        markChange = true;
                    }

                    // down
                    while (bottom <= _sheet.Height && bottom > top && _sheet.sumContentExist.SubmatrixSum(new Boundary(bottom, bottom, left, right)) == 0)
                    {
                        bottom--;
                        markChange = true;
                    }
                }

                var newBox = new Boundary(top, bottom, left, right);
                if (!box.Equals(newBox))
                {
                    removedBoxes.Add(box);
                    if (left < right && top < bottom)
                    {
                        appendBoxes.Add(newBox);
                    }
                }
            }

            Utils.RemoveAndAppendCandidates(removedBoxes, appendBoxes, _boxes);
            _boxes = Utils.DistinctBoxes(_boxes);
        }

        private void CutHeaderFormatFilter()
        {
            // two candidate _boxes, with their headers overlapping each others
            var removedBoxes = new HashSet<Boundary>();
            var appendBoxes = new HashSet<Boundary>();

            foreach (var box in _boxes)
            {
                // As evaluated, removing this check can keep the accuracy while simplifying the logic
                ////if (!IsHeaderUp(Utils.UpRow(box)))
                ////    continue;

                var (left, right) = (box.left, box.right);
                for (; right < _sheet.Width; right++)
                {
                    var rightCell = new Boundary(box.top, box.top, right, right);
                    var rightColor = _sheet.sumColor.SubmatrixSum(rightCell);
                    var rightBorder = _sheet.sumBorderRow.SubmatrixSum(rightCell);
                    var nextCell = new Boundary(box.top, box.top, right + 1, right + 1);
                    var nextColor = _sheet.sumColor.SubmatrixSum(nextCell);
                    var nextBorder = _sheet.sumBorderRow.SubmatrixSum(nextCell);
                    var nextContent = _sheet.sumContent.SubmatrixSum(nextCell);
                    if (nextContent == 0 || nextColor + nextBorder == 0 || nextColor != rightColor || nextBorder != rightBorder)
                        break;
                }

                for (; left > 1; left--)
                {
                    var leftCell = new Boundary(box.top, box.top, left, left);
                    var leftColor = _sheet.sumColor.SubmatrixSum(leftCell);
                    var leftBorder = _sheet.sumBorderRow.SubmatrixSum(leftCell);
                    var prevCell = new Boundary(box.top, box.top, left - 1, left - 1);
                    var prevColor = _sheet.sumColor.SubmatrixSum(prevCell);
                    var prevBorder = _sheet.sumBorderRow.SubmatrixSum(prevCell);
                    var prevContent = _sheet.sumContent.SubmatrixSum(prevCell);
                    if (prevContent == 0 || prevColor + prevBorder == 0 || prevColor != leftColor || prevBorder != leftBorder)
                        break;
                }

                if (right != box.right || left != box.left)
                {
                    removedBoxes.Add(box);
                    appendBoxes.Add(new Boundary(box.top, box.bottom, left, right));
                }
            }

            Utils.RemoveAndAppendCandidates(removedBoxes, appendBoxes, _boxes);
        }

        private void AddCompactRegionGrowth2()
        {
            // append the candidates proposed that not overlap with anyone in the current boxes
            var appendBoxes = _regionGrowthBoxes.Where(box =>
            {
                int contentSum = _sheet.sumContentExist.SubmatrixSum(box);
                int textDistinctCount = _sheet.TextDistinctCount(box);
                return !IsOverlapOrEqual(box, _boxes)
                    && contentSum >= System.Math.Min(8, 2 * ((box.bottom - box.top + 1) * (box.right - box.left + 1) - 3))
                    && _sheet.sumContentExist.SubmatrixSum(new Boundary(box.top - 1, box.bottom + 1, box.left - 1, box.right + 1)) - contentSum <= 10
                    && textDistinctCount > System.Math.Max(box.bottom - box.top + 2, box.right - box.left + 2);
            });

            Utils.AppendTheseCandidates(appendBoxes, _boxes);
        }

        private static bool IsOverlapOrEqual(Boundary box1, List<Boundary> boxes2, bool exceptForward = false, bool exceptBackward = false, bool exceptSuppression = false)
        {
            return boxes2 != null && boxes2.Any(box2 => Utils.isOverlap(box1, box2, exceptForward, exceptBackward, exceptSuppression));
        }
    }
}
