# -*- coding: utf-8 -*-

import functools

ORIGINAL_FN = '__original_fn__'


def advice_add(module, original_fn_name, new_fn=None):
    def wrapper(fn):
        original_fn = getattr(module, original_fn_name)

        @functools.wraps(fn)
        def wrapped(*args, **kwargs):
            return fn(original_fn, *args, **kwargs)

        setattr(wrapped, ORIGINAL_FN, original_fn)
        setattr(module, original_fn_name, wrapped)
        return wrapped

    if new_fn is not None:
        return wrapper(new_fn)

    return wrapper


def advice_remove(module, fn_name):
    adviced_fn = getattr(module, fn_name)
    original_fn = getattr(adviced_fn, ORIGINAL_FN, None)
    if original_fn is None:
        raise RuntimeError(f'{fn_name} in {module} has not been adviced !')

    setattr(module, fn_name, original_fn)
    return adviced_fn
