/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ParallelSentencePanel
extends JPanel {
    private final List<JLabel> sourceWords = new ArrayList<JLabel>();
    private final List<JLabel> targetWords = new ArrayList<JLabel>();
    private final List<WordAlignment> wordAlignments = new ArrayList<WordAlignment>();
    private final JPanel sourcePanel = new JPanel();
    private final JPanel targetPanel = new JPanel();
    private final JTextField editableArea = new JTextField();

    public ParallelSentencePanel(final ParallelSentence parallelSentence, final PostEditor postEditor) {
        String word;
        String[] stringArray = parallelSentence.sourceWords;
        int n = parallelSentence.sourceWords.length;
        int n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.sourceWords.add(new JLabel(word));
            ++n2;
        }
        stringArray = parallelSentence.targetWords;
        n = parallelSentence.targetWords.length;
        n2 = 0;
        while (n2 < n) {
            word = stringArray[n2];
            this.targetWords.add(new JLabel(word));
            ++n2;
        }
        String previouslyEditedText = parallelSentence.getEditedTranslation();
        this.editableArea.setText(previouslyEditedText);
        this.editableArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
            }
        });
        this.editableArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
            }
        });
        this.editableArea.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
                postEditor.setSentenceNumber(parallelSentence.sentenceNumber);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
                parallelSentence.setEditedTranslation(ParallelSentencePanel.this.editableArea.getText());
            }
        });
        WordAlignment[] wordAlignmentArray = parallelSentence.alignmentPoints;
        int n3 = parallelSentence.alignmentPoints.length;
        n = 0;
        while (n < n3) {
            WordAlignment a = wordAlignmentArray[n];
            this.wordAlignments.add(a);
            ++n;
        }
        for (JLabel sourceWord : this.sourceWords) {
            this.sourcePanel.add(sourceWord);
        }
        for (JLabel targetWord : this.targetWords) {
            this.targetPanel.add(targetWord);
        }
        this.sourcePanel.setBackground(Color.WHITE);
        this.targetPanel.setBackground(Color.WHITE);
        this.sourcePanel.setMaximumSize(this.sourcePanel.getMinimumSize());
        this.targetPanel.setMaximumSize(this.targetPanel.getMinimumSize());
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.sourcePanel);
        this.add(Box.createRigidArea(new Dimension(0, 20)));
        this.add(this.targetPanel);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
        this.add(this.editableArea);
        this.add(Box.createRigidArea(new Dimension(0, 15)));
        this.setMaximumSize(this.getMinimumSize());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        g.setColor(Color.BLACK);
        for (WordAlignment a : this.wordAlignments) {
            JLabel source = this.sourceWords.get(a.sourceIndex);
            JLabel target = this.targetWords.get(a.targetIndex);
            Rectangle sourceBounds = source.getBounds();
            Rectangle targetBounds = target.getBounds();
            Point sourcePoint = this.sourcePanel.getLocation();
            Point targetPoint = this.targetPanel.getLocation();
            g.drawLine(sourcePoint.x + sourceBounds.x + sourceBounds.width / 2, sourcePoint.y + sourceBounds.y + sourceBounds.height, targetPoint.x + targetBounds.x + targetBounds.width / 2, targetPoint.y + targetBounds.y);
        }
    }
}

