-- This module will transliterate Kildin Sami language text.

local export = {}

local tt = {
	["А"]='A', ["а"]='a',
	["Ӓ"]="ʹa", ["ӓ"]="ʹa",
	["Б"]='B', ["б"]='b',
	["В"]='V', ["в"]='v',
	["Г"]='G', ["г"]='g',
	["Д"]='D', ["д"]='d',
	["Е"]='Je', ["е"]='je',
	["Ё"]="Jo", ["ё"]="jo",
	["Ж"]='Ž', ["ж"]='ž',
	["З"]='Z', ["з"]='z',
	["Һ"]="H", ["һ"]="h", ["ʼ"]="h",
	["И"]='I', ["и"]='i',
	["Ӣ"]="Ī", ["ӣ"]="ī",
	["Й"]="J", ["й"]="j",
	["Ј"]="J̥", ["ј"]="j̥", ["Ҋ"]="J̥", ["ҋ"]="j̥",
	["К"]='K', ["к"]='k',
	["Л"]='L', ["л"]='l',
	["Ӆ"]='L̥', ["ӆ"]='l̥',
	["М"]='M', ["м"]='m',
	["Ӎ"]="M̥", ["ӎ"]="m̥",
	["Н"]='N', ["н"]='n',
	["Ӊ"]="N̥", ["ӊ"]="n̥",
	["Ӈ"]="Ŋ", ["ӈ"]="ŋ",
	["О"]='O', ["о"]='o',
	["П"]='P', ["п"]='p', 
	["Р"]='R', ["р"]='r',
	["Ҏ"]="R̥", ["ҏ"]="r̥",
	["С"]='S', ["с"]='s',
	["Т"]='T', ["т"]='t',
	["У"]='U', ["у"]='u', 
	["Ӯ"]="Ū", ["ӯ"]="ū",
	["Ф"]='F', ["ф"]='f',
	["Х"]='X', ["х"]='x',
	["Ц"]='C', ["ц"]='c',
	["Ч"]='Č', ["ч"]='č',
	["Ш"]='Š', ["ш"]='š',
	["Щ"]="Šč", ["щ"]="šč",
	["Ы"]="Ɨ", ["ы"]="ɨ",
	["Ъ"]="", ["ъ"]="",
	["Ь"]="ʹ", ["ь"]="ʹ", ["Ҍ"]="ʹ", ["ҍ"]="ʹ",
	["Э"]="E", ["э"]="e",
	["Ӭ"]="ʹE", ["ӭ"]="ʹe",
	["Ю"]="Ju", ["ю"]="ju",
	["Я"]="Ja", ["я"]="ja",
}


local vowel = "аӓеёиӣоуӯыэӭюяАӒЕЁИӢОУӮЫЭӬЮЯ"

function export.tr(text, lang, sc)
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])е", "%1ьэ")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])ё", "%1ьо")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])ю", "%1ьу")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])я", "%1ьа")
	
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])Е", "%1ЬЭ")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])Ё", "%1ЬО")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])Ю", "%1ЬУ")
	text = mw.ustring.gsub(text, "([^" .. vowel .. "НнЪъЬьҌҍ])Я", "%1ЬА")
	
	text = mw.ustring.gsub(text, "([нН])ь", "%1й")
	text = mw.ustring.gsub(text, "НЬ", "НЙ")
	
	return (mw.ustring.gsub(text, '.', tt))
end

return export