#include "vocab.ih"

uint32_t Vocab::getId(uint32_t beg, uint32_t end)
{
    uint32_t split = (end + beg) / 2;
    uint32_t begIdx = d_idxs[split]; //can split be zero here?
    uint32_t lenSplit = strlen(&d_vocab[d_idxs[split]]);

    // TODO possible without allocating new cstring?
    char splitWord[lenSplit+1];
    strncpy(&splitWord[0], &d_vocab[begIdx], lenSplit);
    splitWord[lenSplit] = '\0';
    int comp = strcmp(d_searchWord, splitWord);
    //cout << split << '\t' << comp << '\t' << splitWord << '\n' << '\n';
    if (beg == end || beg == split)
        return 0;
    if (comp > 0)
        return getId(split, end);
    if (comp < 0)
        return getId(beg, split);
    return split;
}
