#include "model.ih"

void Model::sortCands()
{
    vector<pair<double, string>> rankedCands;
    for (size_t candIdx = 0; candIdx != d_cands[d_wordIdx].size(); ++candIdx)
    {   
        if (!d_config->caps)
            transform(d_cands[d_wordIdx][candIdx].begin(), d_cands[d_wordIdx][candIdx].end(), 
                                d_cands[d_wordIdx][candIdx].begin(), ::tolower);
        rankedCands.push_back(make_pair(d_results[d_wordIdx][candIdx], 
                             d_cands[d_wordIdx][candIdx]));
    }
    rankedCands[0].first = rankedCands[0].first / d_config->weight;
    
    if (!d_config->goldErrDet)
        sort(rankedCands.begin(), rankedCands.end());
    else
        sort(rankedCands.rbegin(), rankedCands.rend());
    for (size_t candIdx = 0; candIdx != d_cands[d_wordIdx].size(); ++candIdx)
    {
        d_cands[d_wordIdx][candIdx] = rankedCands[candIdx].second;
        d_results[d_wordIdx][candIdx] = 1 - rankedCands[candIdx].first;
    }
    d_config->totalCands += d_cands[d_wordIdx].size();
}
