#ifndef _DEPLABEL_H
#define _DEPLABEL_H
#include "token.h"
#include "pos_pos_lab.h"
class TDepLabel {
protected:
	Token tokenizer;
	Pos_Pos_Label pplmap;
public:
	TDepLabel();
	~TDepLabel();

	int code(const ttoken & s);
	const ttoken & key(const int & token);
	int count();
	const int START = 1;
	const int ROOT = 1;
	void add(const ttoken & s);
	void init() { pplmap.init(); tokenizer.init(); }
	Token & getTokenizer();
	Pos_Pos_Label & getPPL() { return TDepLabel::pplmap; }
	void addPPL(const TriGram<int> &T) { TDepLabel::pplmap.insert(T); }
	bool findPPL(const TriGram<int> &T) { return TDepLabel::pplmap.find(T); }
};

inline TDepLabel::TDepLabel() = default;

inline TDepLabel::~TDepLabel() = default;

inline int TDepLabel::count() {
	return TDepLabel::tokenizer.count();
}

inline int TDepLabel::code(const ttoken & s) {
	return TDepLabel::tokenizer.lookup(s);
}

inline const ttoken & TDepLabel::key(const int & index) {
	return TDepLabel::tokenizer.key(index);
}

inline Token & TDepLabel::getTokenizer() {
	return tokenizer;
}

inline void TDepLabel::add(const ttoken & s) {
	tokenizer.add(s);
}

#endif
