/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.GeneralizedCoordination;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GeneralizedCoordinationReader
implements Iterable<List<GeneralizedCoordination>> {
    File file;

    public GeneralizedCoordinationReader(String file) {
        this.file = new File(file);
    }

    public GeneralizedCoordinationReader(File file) {
        this.file = file;
    }

    @Override
    public Iterator<List<GeneralizedCoordination>> iterator() {
        return new GCIterator();
    }

    public List<List<GeneralizedCoordination>> readAll() {
        ArrayList<List<GeneralizedCoordination>> ret = new ArrayList<List<GeneralizedCoordination>>();
        for (List<GeneralizedCoordination> coord : this) {
            ret.add(coord);
        }
        return ret;
    }

    class GCIterator
    implements Iterator<List<GeneralizedCoordination>> {
        BufferedReader br;
        String line;

        public GCIterator() {
            try {
                this.br = new BufferedReader(new FileReader(GeneralizedCoordinationReader.this.file));
                this.line = this.br.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            return this.line != null;
        }

        @Override
        public List<GeneralizedCoordination> next() {
            ArrayList<GeneralizedCoordination> ret = new ArrayList<GeneralizedCoordination>();
            while (this.line != null && !this.line.isEmpty()) {
                String[] c;
                String[] w;
                String[] fields = this.line.split("\\s");
                GeneralizedCoordination.Direction d = GeneralizedCoordination.Direction.COORD2WORD;
                if (fields[2].contains("|")) {
                    w = fields[0].substring(1, fields[0].length() - 1).split("-", 2);
                    if (fields[1].equals("->")) {
                        d = GeneralizedCoordination.Direction.WORD2COORD;
                    }
                    c = fields[2].substring(1, fields[2].length() - 1).split("\\|");
                } else {
                    w = fields[2].substring(1, fields[2].length() - 1).split("-", 2);
                    if (fields[1].equals("<-")) {
                        d = GeneralizedCoordination.Direction.WORD2COORD;
                    }
                    c = fields[0].substring(1, fields[0].length() - 1).split("\\|");
                }
                if (w[1].contains("|")) {
                    throw new RuntimeException("many words!");
                }
                int wp = Integer.parseInt(w[0]) + 1;
                if (c.length > 1) {
                    ArrayList<Integer> cps = new ArrayList<Integer>();
                    ArrayList<String> cs = new ArrayList<String>();
                    int i = 0;
                    while (i < c.length) {
                        String[] cc = c[i].split("-", 2);
                        cps.add(Integer.parseInt(cc[0]) + 1);
                        cs.add(cc[1]);
                        ++i;
                    }
                    ret.add(new GeneralizedCoordination(wp, w[1], cps, cs, d, fields[3].equals("1")));
                }
                try {
                    this.line = this.br.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.line = this.br.readLine();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return ret;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

