/*
 * Decompiled with CFR 0.152.
 */
package fig.exec;

import fig.basic.CharEncUtils;
import fig.basic.ClassInitializer;
import fig.basic.Exceptions;
import fig.basic.Fmt;
import fig.basic.IOUtils;
import fig.basic.ListUtils;
import fig.basic.LogInfo;
import fig.basic.Option;
import fig.basic.OptionsParser;
import fig.basic.OrderedStringMap;
import fig.basic.StopWatchSet;
import fig.basic.StrUtils;
import fig.basic.SysInfoUtils;
import fig.basic.Utils;
import fig.exec.MonitorThread;
import fig.record.Record;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class Execution {
    @Option(gloss="Whether to create a thread to monitor the status of this execution.")
    public static boolean monitor = true;
    @Option(gloss="Directory to put all output files; if empty, use execPoolDir.")
    public static String execDir;
    @Option(gloss="Directory which contains all the executions.")
    public static String execPoolDir;
    @Option(gloss="Overwrite the contents of the execDir if it doesn't exist (e.g., when running a thunk).")
    public static boolean overwriteExecDir;
    @Option(gloss="Simply print options and exit.")
    public static boolean printOptionsAndExit;
    @Option(gloss="Miscellaneous options (written to options.map and output.map, displayed in servlet); example: a=3 b=4")
    public static ArrayList<String> miscOptions;
    @Option(gloss="Name of the view to add this execution to in the servlet (simply creates an addToView file).")
    public static ArrayList<String> addToView;
    @Option(gloss="Character encoding")
    public static String charEncoding;
    @Option(gloss="Name of jar files to load prior to execution.  This is so that when the JARs change underneath us, we don't crash.")
    public static ArrayList<String> jarFiles;
    @Option(gloss="Whether to wrap everything around a main() track")
    public static boolean startMainTrack;
    private static String actualExecDir;
    public static boolean ignoreUnknownOpts;
    static OrderedStringMap inputMap;
    private static OrderedStringMap outputMap;
    private static OptionsParser parser;
    private static MonitorThread monitorThread;
    static int exitCode;
    static boolean shouldBail;
    private static List<ExitHandler> exitHandlers;

    static {
        printOptionsAndExit = false;
        miscOptions = new ArrayList();
        addToView = new ArrayList();
        jarFiles = new ArrayList();
        startMainTrack = true;
        ignoreUnknownOpts = false;
        inputMap = new OrderedStringMap();
        outputMap = new OrderedStringMap();
        exitCode = 0;
        shouldBail = false;
        exitHandlers = new ArrayList<ExitHandler>();
    }

    public static String getActualExecDir() {
        return actualExecDir;
    }

    private static boolean shouldCreate() {
        return execPoolDir != null || execDir != null;
    }

    public static boolean shouldBail() {
        return shouldBail;
    }

    private static void mkdirHard(File f) {
        if (!f.mkdir()) {
            LogInfo.stderr.println("Cannot create directory: " + f);
            System.exit(1);
        }
    }

    public static String createActualExecDir() {
        if (!StrUtils.isEmpty(execPoolDir) && !new File(execPoolDir).isDirectory()) {
            throw Exceptions.bad("Execution pool directory '" + execPoolDir + "' doesn't exist");
        }
        if (!StrUtils.isEmpty(execDir)) {
            boolean exists = new File(execDir).isDirectory();
            if (exists && !overwriteExecDir) {
                throw Exceptions.bad("Directory already exists and overwrite flag is false");
            }
            if (!exists) {
                Execution.mkdirHard(new File(execDir));
            }
            actualExecDir = execDir;
            return actualExecDir;
        }
        HashSet<String> files = new HashSet<String>();
        String[] stringArray = new File(execPoolDir).list();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            files.add(f);
            ++n2;
        }
        boolean numFailures = false;
        int i = 0;
        while (true) {
            File f = new File(execPoolDir, String.valueOf(i) + ".exec");
            if (!files.contains(String.valueOf(i) + ".exec")) {
                Execution.mkdirHard(f);
                actualExecDir = f.toString();
                return actualExecDir;
            }
            ++i;
        }
    }

    public static String getFile(String file) {
        if (StrUtils.isEmpty(actualExecDir)) {
            return null;
        }
        if (StrUtils.isEmpty(file)) {
            return null;
        }
        return new File(actualExecDir, file).toString();
    }

    public static void linkFileToExec(String realFileName, String file) {
        if (StrUtils.isEmpty(realFileName) || StrUtils.isEmpty(file)) {
            return;
        }
        File f = new File(realFileName);
        Utils.createSymLink(f.getAbsolutePath(), Execution.getFile(file));
    }

    public static void linkFileFromExec(String file, String realFileName) {
        if (StrUtils.isEmpty(realFileName) || StrUtils.isEmpty(file)) {
            return;
        }
        File f = new File(realFileName);
        Utils.createSymLink(Execution.getFile(file), f.getAbsolutePath());
    }

    public static boolean getBooleanInput(String s) {
        String t = inputMap.get(s, "0");
        return t.equals("true") || t.equals("1");
    }

    public static synchronized String getInput(String s) {
        return (String)inputMap.get(s);
    }

    public static synchronized void putOutput(String s, Object t) {
        outputMap.put(s, StrUtils.toString(t));
    }

    public static synchronized void printOutputMapToStderr() {
        outputMap.print(LogInfo.stderr);
    }

    public static synchronized void printOutputMap(String path) {
        if (StrUtils.isEmpty(path)) {
            return;
        }
        String tmpPath = String.valueOf(path) + ".tmp";
        if (outputMap.printEasy(tmpPath)) {
            new File(tmpPath).renameTo(new File(path));
        }
    }

    public static void setExecStatus(String newStatus, boolean override) {
        String oldStatus = (String)outputMap.get("exec.status");
        if (oldStatus == null || oldStatus.equals("running")) {
            override = true;
        }
        if (override) {
            Execution.putOutput("exec.status", newStatus);
        }
    }

    public static void putLogRec(String key, Object value) {
        LogInfo.logss("%s = %s", key, value);
        Record.add(key, value);
        Execution.putOutput(key, value);
    }

    static OrderedStringMap getInfo() {
        OrderedStringMap map = new OrderedStringMap();
        map.put("Date", SysInfoUtils.getCurrentDateStr());
        map.put("Host", SysInfoUtils.getHostName());
        map.put("CPU speed", SysInfoUtils.getCPUSpeedStr());
        map.put("Max memory", SysInfoUtils.getMaxMemoryStr());
        map.put("Num CPUs", (Object)SysInfoUtils.getNumCPUs());
        return map;
    }

    public static void init(String[] args, Object ... objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof OptionsParser) {
                parser = (OptionsParser)objects[i];
                objects[i] = null;
            }
            ++i;
        }
        if (parser == null) {
            parser = new OptionsParser();
        }
        parser.register("log", LogInfo.class);
        parser.register("exec", Execution.class);
        parser.registerAll(objects);
        parser.setDefaultDirFileName("options.map");
        parser.setIgnoreOptsFromFileName("options.map", ListUtils.newList("log.file", "exec.execDir", "exec.execPoolDir"));
        if (ignoreUnknownOpts) {
            parser.ignoreUnknownOpts();
        }
        if (!parser.parse(args)) {
            System.exit(1);
        }
        if (charEncoding != null) {
            CharEncUtils.setCharEncoding(charEncoding);
        }
        if (printOptionsAndExit) {
            parser.getOptionPairs().print(LogInfo.stdout);
            System.exit(0);
        }
        if (Execution.shouldCreate()) {
            Execution.createActualExecDir();
            LogInfo.file = Execution.getFile("log");
            for (String jarFile : jarFiles) {
                Utils.systemHard(String.format("cp %s %s", jarFile, actualExecDir));
            }
        } else {
            LogInfo.file = "";
        }
        Execution.initializeJars();
        for (String opt : miscOptions) {
            String[] tokens = opt.split("=");
            if (tokens.length != 2) continue;
            Execution.putOutput(tokens[0], tokens[1]);
        }
        LogInfo.init();
        Record.init(Execution.getFile("record"));
        if (startMainTrack) {
            LogInfo.begin_track_printAll("main()", new Object[0]);
        }
        if (actualExecDir != null) {
            LogInfo.logs("Execution directory: " + actualExecDir);
        }
        Execution.getInfo().printEasy(Execution.getFile("info.map"));
        Execution.printOptions();
        if (Execution.shouldCreate() && addToView.size() > 0) {
            IOUtils.printLinesHard(Execution.getFile("addToView"), addToView);
        }
        if (monitor) {
            monitorThread = new MonitorThread();
            monitorThread.start();
        }
    }

    public static void add(Object o) {
        parser.registerAll(new Object[]{o});
        Execution.printOptions();
    }

    private static void initializeJars() {
        if (jarFiles.size() > 0) {
            ArrayList<String> names = new ArrayList<String>();
            for (String jarFile : jarFiles) {
                names.add(new File(jarFile).getName());
            }
            LogInfo.stderr.println("Loading JAR files: " + StrUtils.join(names));
            for (String jarFile : jarFiles) {
                String jarPath = Execution.shouldCreate() ? new File(actualExecDir, new File(jarFile).getName()).getPath() : jarFile;
                ClassInitializer.initializeJar(jarPath);
            }
        }
    }

    public static void printOptions() {
        parser.getOptionPairs().printEasy(Execution.getFile("options.map"));
        parser.getOptionStrings().printEasy(Execution.getFile("options.help"));
    }

    public static void raiseException(Throwable t) {
        LogInfo.error(t + ":\n" + StrUtils.join(t.getStackTrace(), "\n"));
        t = t.getCause();
        if (t != null) {
            LogInfo.error("Caused by " + t + ":\n" + StrUtils.join(t.getStackTrace(), "\n"));
        }
        Execution.putOutput("exec.status", "exception");
        exitCode = 1;
    }

    public static void finish() {
        if (actualExecDir != null) {
            outputMap.put("exec.disk", Fmt.bytesToString(IOUtils.diskUsageBytesUnder(actualExecDir)));
        }
        Record.finish();
        if (monitor) {
            monitorThread.finish();
        }
        Execution.setExecStatus(shouldBail ? "bailed" : "done", false);
        outputMap.printEasy(Execution.getFile("output.map"));
        StopWatchSet.getStats().printEasy(Execution.getFile("time.map"));
        if (actualExecDir != null) {
            LogInfo.logs("Execution directory: " + actualExecDir);
        }
        if (LogInfo.getNumErrors() > 0 || LogInfo.getNumWarnings() > 0) {
            LogInfo.stderr.printf("%d errors, %d warnings\n", LogInfo.getNumErrors(), LogInfo.getNumWarnings());
        }
        if (startMainTrack) {
            LogInfo.end_track();
        }
        System.exit(exitCode);
    }

    public static void run(String[] args, Object ... objects) {
        Execution.runWithObjArray(args, objects);
    }

    public static void runWithObjArray(String[] args, Object[] objects) {
        Execution.init(args, objects);
        Object mainObj = objects[0] instanceof String ? objects[1] : objects[0];
        try {
            ((Runnable)mainObj).run();
        }
        catch (Throwable t) {
            Execution.raiseException(t);
        }
        Execution.finish();
    }

    public static void addExitHandler(ExitHandler handler) {
        exitHandlers.add(handler);
    }

    public static void beforeExit() {
        for (ExitHandler handler : exitHandlers) {
            handler.run();
        }
    }

    public static void runSystemCommand(String header, final String cmd) {
        LogInfo.begin_track_printAll(header, new Object[0]);
        LogInfo.logs("%s", cmd);
        try {
            String line;
            final Process process = Utils.openSystem(cmd);
            Execution.addExitHandler(new ExitHandler(){

                @Override
                public void run() {
                    LogInfo.logs("KILLING PROCESS OF COMMAND: %s", cmd);
                    process.destroy();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            });
            process.getOutputStream().close();
            LogInfo.begin_track_printAll("stdout", new Object[0]);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = in.readLine()) != null) {
                LogInfo.logs("%s", line);
            }
            in.close();
            LogInfo.end_track();
            LogInfo.begin_track_printAll("stderr", new Object[0]);
            BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while ((line = err.readLine()) != null) {
                LogInfo.logs("%s", line);
            }
            err.close();
            LogInfo.end_track();
            Utils.closeSystemHard(cmd, process);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogInfo.end_track();
    }

    public static interface ExitHandler {
        public void run();
    }
}

